/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import impl.owls.grounding.AtomicGroundingImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.OWLetOnt;
import org.mindswap.query.ValueMap;
import org.owlet.helpers.ReflectionHelpers;

public class JavaAtomicGroundingImpl
extends AtomicGroundingImpl
implements JavaAtomicGrounding {
    OWLIndividualList inParamList = null;

    public JavaAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    public void setClaz(String claz) {
        this.setProperty(OWLetOnt.javaClass, claz);
    }

    public String getClaz() {
        return this.getPropertyAsString(OWLetOnt.javaClass);
    }

    public void setMethod(String method) {
        this.setProperty(OWLetOnt.javaMethod, method);
    }

    public String getMethod() {
        return this.getPropertyAsString(OWLetOnt.javaMethod);
    }

    public URL getDescriptionURL() {
        return null;
    }

    public void addMessageMap(Parameter owlsParameter, String groundingParameter, String xsltTransformation) {
    }

    public MessageMapList getInputMap() {
        return null;
    }

    public MessageMapList getOutputMap() {
        return null;
    }

    public ValueMap invoke(ValueMap values) throws ExecutionException {
        return this.invoke(values, OWLFactory.createKB());
    }

    public ValueMap invoke(ValueMap values, OWLKnowledgeBase kb) throws ExecutionException {
        int i;
        Class<?> claz = null;
        Method method = null;
        Class[] params = null;
        Object[] paramValues = null;
        ValueMap results = new ValueMap();
        Object result = null;
        String strClaz = this.getClaz();
        if (strClaz == null || strClaz.equals("")) {
            throw new ExecutionException("JavaAtomicGrounding: No Java Class defined in Grounding!");
        }
        String strMethod = this.getMethod();
        if (strMethod == null || strMethod.equals("")) {
            throw new ExecutionException("JavaAtomicGrounding: No Java Method defined in Grounding!");
        }
        params = new Class[this.getInputOWLSParamsSize()];
        for (i = 0; i < this.getInputOWLSParamsSize(); ++i) {
            params[i] = this.getInputJavaParamAt(i);
        }
        try {
            claz = Class.forName(strClaz);
            method = claz.getDeclaredMethod(strMethod, params);
        }
        catch (ClassNotFoundException e) {
            throw new ExecutionException("JavaAtomicGrounding: Class defined in Grounding not found.");
        }
        catch (NoSuchMethodException e) {
            throw new ExecutionException("JavaAtomicGrounding: Method defined in Grounding not found.");
        }
        catch (Exception e) {
            throw new ExecutionException("JavaAtomicGrounding: " + e.getClass().toString() + " ocurred: " + e.getMessage());
        }
        paramValues = new Object[this.getInputOWLSParamsSize()];
        for (i = 0; i < params.length; ++i) {
            OWLValue owlValue = values.getValue(this.getInputOWLSParamAt(i));
            if (!owlValue.isDataValue()) continue;
            paramValues[i] = ReflectionHelpers.getCastedObjectFromStringValue(((OWLDataValue)owlValue).getLexicalValue(), params[i]);
        }
        try {
            Object obj = claz.newInstance();
            if (method.getReturnType().toString().equalsIgnoreCase("void")) {
                method.invoke(obj, paramValues);
            } else {
                result = method.invoke(obj, paramValues);
            }
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("JavaAtomicGrounding: Error in executed method\n" + e.getTargetException().toString() + " ocurred: ");
        }
        catch (Exception e) {
            throw new ExecutionException("JavaAtomicGrounding: Error while executing method\n" + e.getClass().toString() + " ocurred: ");
        }
        if (result != null) {
            Parameter param = this.getOutputOWLSParam();
            if (param == null) {
                throw new ExecutionException("JavaAtomicGrounding: Output in Grounding not specified although method provides a return value.");
            }
            if (param.getParamType().isDataType()) {
                results.setValue(param, EntityFactory.createDataValue(result));
            } else {
                results.setValue(param, kb.getBaseOntology().parseLiteral(result.toString()));
            }
        }
        return results;
    }

    private Parameter getOutputOWLSParam() {
        OWLIndividual owlsParam = this.getProperty(OWLetOnt.javaOutput).getProperty(OWLetOnt.owlsParameter);
        return owlsParam == null ? null : (Parameter)owlsParam.castTo(Parameter.class);
    }

    private void createInputOWLSParamList() {
        if (this.inParamList == null) {
            this.inParamList = this.getProperties(OWLetOnt.hasJavaParameter);
        }
    }

    private Parameter getInputOWLSParamAt(int index) {
        this.createInputOWLSParamList();
        if (index >= this.getInputOWLSParamsSize()) {
            return null;
        }
        for (int i = 0; i < this.getInputOWLSParamsSize(); ++i) {
            OWLDataValue paramIndex = this.inParamList.individualAt(i).getProperty(OWLetOnt.paramIndex);
            if (!paramIndex.getLexicalValue().equals(Integer.toString(index + 1))) continue;
            OWLIndividual owlsParam = this.inParamList.individualAt(index).getProperty(OWLetOnt.owlsParameter);
            return owlsParam == null ? null : (Parameter)owlsParam.castTo(Parameter.class);
        }
        return null;
    }

    private Class getInputJavaParamAt(int index) {
        Object javaClass = null;
        this.createInputOWLSParamList();
        if (index >= this.getInputOWLSParamsSize()) {
            return null;
        }
        for (int i = 0; i < this.getInputOWLSParamsSize(); ++i) {
            OWLDataValue paramIndex = this.inParamList.individualAt(i).getProperty(OWLetOnt.paramIndex);
            if (!paramIndex.getLexicalValue().equals(Integer.toString(index + 1))) continue;
            String javaType = this.inParamList.individualAt(i).getProperty(OWLetOnt.javaType).getValue().toString();
            return ReflectionHelpers.getClassFromString(javaType);
        }
        return null;
    }

    private int getInputOWLSParamsSize() {
        this.createInputOWLSParamList();
        return this.inParamList.size();
    }

    public void setOutputVar(String name, String type, Output owlsParameter) {
        OWLIndividual ind = this.getOntology().createInstance(OWLetOnt.JavaVariable, URI.create(name));
        ind.setProperty(OWLetOnt.javaType, type);
        ind.setProperty(OWLetOnt.owlsParameter, owlsParameter);
        this.setProperty(OWLetOnt.javaOutput, ind);
    }

    public void setInputVar(String name, String type, int index, Input owlsParameter) {
        OWLIndividual ind = this.getOntology().createInstance(OWLetOnt.JavaParameter, URI.create(name));
        ind.setProperty(OWLetOnt.javaType, type);
        ind.setProperty(OWLetOnt.owlsParameter, owlsParameter);
        ind.setProperty(OWLetOnt.paramIndex, Integer.toString(index));
        this.addProperty(OWLetOnt.hasJavaParameter, ind);
    }
}

