/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.UPnPStatus;
import impl.owls.grounding.AtomicGroundingImpl;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.w3c.dom.Node;

public class UPnPAtomicGroundingImpl
extends AtomicGroundingImpl
implements UPnPAtomicGrounding {
    public UPnPAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    public MessageMapList getInputMap() {
        return OWLSFactory.createMessageMapList(this.getProperties(FLAServiceOnt.upnpInputMapping));
    }

    public MessageMapList getOutputMap() {
        return OWLSFactory.createMessageMapList(this.getProperties(FLAServiceOnt.upnpOutputMapping));
    }

    public void setUPnPService(String service) {
        this.setProperty(FLAServiceOnt.upnpServiceID, service);
    }

    public String getUPnPService() {
        return this.getPropertyAsString(FLAServiceOnt.upnpServiceID);
    }

    public void setUPnPAction(String action) {
        this.setProperty(FLAServiceOnt.upnpCommand, action);
    }

    public String getUPnPAction() {
        return this.getPropertyAsString(FLAServiceOnt.upnpCommand);
    }

    public URL getDescriptionURL() {
        try {
            ControlPoint cp = new ControlPoint();
            Device device = cp.getProxyDevice(this.getUPnPDescription());
            String url = device.getPresentationURL();
            cp.stop();
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setUPnPDescription(String description) {
        this.setProperty(FLAServiceOnt.upnpDeviceURL, description);
    }

    public String getUPnPDescription() {
        return this.getPropertyAsString(FLAServiceOnt.upnpDeviceURL);
    }

    public ValueMap invoke(ValueMap values) {
        return this.invoke(values, OWLFactory.createKB());
    }

    public ValueMap invoke(ValueMap values, OWLKnowledgeBase kb) {
        ControlPoint cp = new ControlPoint();
        Device device = cp.getProxyDevice(this.getUPnPDescription());
        Service service = device.getService(this.getUPnPService());
        Action action = service.getAction(this.getUPnPAction());
        ValueMap results = new ValueMap();
        MessageMapList inputMapList = this.getInputMap();
        ArgumentList inArguments = action.getInputArgumentList();
        for (int i = 0; i < inArguments.size(); ++i) {
            Object value;
            Argument in = inArguments.getArgument(i);
            MessageMap mp = inputMapList.getMessageMap(in.getName());
            Parameter param = mp.getOWLSParameter();
            Object inputValue = value = values.getValue(param);
            System.out.println("value = " + value);
            if (mp.getTransformation() != null) {
                value = XSLTEngine.transform(value.toString(), mp.getTransformation());
                Node node = Utils.getAsNode(value.toString());
                inputValue = node.getFirstChild().getNodeValue();
                System.out.println("input value = " + value);
            }
            action.setArgumentValue(mp.getGroundingParameter().toString(), inputValue.toString());
        }
        boolean ctrlRes = action.postControlAction();
        if (!ctrlRes) {
            UPnPStatus err = action.getControlStatus();
            throw new ExecutionException(err.getDescription() + " (" + Integer.toString(err.getCode()) + ")");
        }
        MessageMapList outputMapList = this.getOutputMap();
        ArgumentList outArguments = action.getOutputArgumentList();
        for (int i = 0; i < outArguments.size(); ++i) {
            Argument out = outArguments.getArgument(i);
            MessageMap mp = outputMapList.getMessageMap(out.getName());
            if (mp == null) continue;
            Parameter param = mp.getOWLSParameter();
            String outputValue = null;
            outputValue = mp.getTransformation() == null ? out.getValue() : XSLTEngine.transform(out.getValue().toString(), mp.getTransformation());
            if (param.getParamType().isDataType()) {
                results.setValue(param, EntityFactory.createDataValue((Object)outputValue));
                continue;
            }
            results.setValue(param, kb.parseLiteral(outputValue.toString()));
        }
        return results;
    }

    public void addMessageMap(Parameter owlsParameter, String groundingParameter, String xsltTransformation) {
        MessageMap map = this.getOntology().createUPnPMessageMap();
        map.setOWLSParameter(owlsParameter);
        map.setGroundingParameter(groundingParameter);
        if (xsltTransformation != null && xsltTransformation.length() > 0) {
            map.setTransformation(xsltTransformation);
        }
        this.addMessageMap(map);
    }
}

