/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.owl.list.RDFListImpl;
import java.util.List;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.RDFList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataValue;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.swrl.SWRLIndividual;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SameIndividualAtom;
import org.mindswap.swrl.Variable;

public class AtomListImpl
extends RDFListImpl
implements AtomList {
    public AtomListImpl(OWLIndividual ind) {
        super(ind);
        this.setVocabulary(SWRL.AtomListVocabulary);
    }

    public AtomList add(Atom item) {
        if (this.isEmpty()) {
            return this.insert(item);
        }
        RDFList rest = this.getRest();
        if (rest.isEmpty()) {
            this.setRest(rest.insert(item));
        } else {
            rest.add(item);
        }
        return this;
    }

    public AtomList insert(Atom first) {
        OWLOntology ont = this.getOntology();
        AtomListImpl list = new AtomListImpl(ont.createInstance(this.vocabulary.List()));
        list.setFirst(first);
        list.setRest(this);
        return list;
    }

    public AtomList insertAt(int index, Atom item) {
        return (AtomList)super.insertAt(index, item).castTo(AtomList.class);
    }

    public RDFList insert(OWLValue item) {
        Atom atom = (Atom)item.castTo(Atom.class);
        return this.add(atom);
    }

    public OWLValue getFirstValue() {
        return (Atom)this.getProperty(this.vocabulary.first()).castTo(Atom.class);
    }

    public RDFList getRest() {
        return (RDFList)this.getProperty(this.vocabulary.rest()).castTo(AtomList.class);
    }

    public Atom atomAt(int index) {
        return (Atom)this.get(index);
    }

    public ABoxQuery toQuery() {
        return new ABoxQuery(this);
    }

    public ABoxQuery toQuery(List resultVars) {
        return new ABoxQuery(this, resultVars);
    }

    public SWRLIndividualObject getIndidividualObject(SWRLIndividualObject arg, ValueMap binding) {
        if (arg.isVariable() && binding.hasValue((Variable)((Object)arg))) {
            OWLIndividual ind = (OWLIndividual)binding.getValue((Variable)((Object)arg));
            arg = (SWRLIndividual)ind.castTo(SWRLIndividual.class);
        }
        return arg;
    }

    public SWRLDataObject getDataObject(SWRLDataObject arg, ValueMap binding) {
        if (arg.isVariable() && binding.hasValue((Variable)((Object)arg))) {
            OWLDataValue dv = (OWLDataValue)binding.getValue((Variable)((Object)arg));
            arg = (SWRLDataValue)dv.castTo(SWRLDataValue.class);
        }
        return arg;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AtomList apply(ValueMap binding) {
        void var5_6;
        OWLOntology ont = this.getOntology();
        SWRLFactory swrl = SWRLFactoryCreator.createFactory(ont);
        AtomList newList = swrl.createList();
        AtomListImpl atomListImpl = this;
        while (!var5_6.isEmpty()) {
            void var7_9;
            Atom atom = (Atom)var5_6.getFirst();
            Object var7_10 = null;
            if (atom instanceof ClassAtom) {
                ClassAtom classAtom = (ClassAtom)atom;
                ClassAtom classAtom2 = swrl.createClassAtom(classAtom.getClassPredicate(), this.getIndidividualObject(classAtom.getArgument1(), binding));
            } else if (atom instanceof IndividualPropertyAtom) {
                IndividualPropertyAtom indPropAtom = (IndividualPropertyAtom)atom;
                IndividualPropertyAtom individualPropertyAtom = swrl.createIndividualPropertyAtom(indPropAtom.getPropertyPredicate(), this.getIndidividualObject(indPropAtom.getArgument1(), binding), this.getIndidividualObject(indPropAtom.getArgument2(), binding));
            } else if (atom instanceof DataPropertyAtom) {
                DataPropertyAtom dataPropAtom = (DataPropertyAtom)atom;
                DataPropertyAtom dataPropertyAtom = swrl.createDataPropertyAtom(dataPropAtom.getPropertyPredicate(), this.getIndidividualObject(dataPropAtom.getArgument1(), binding), this.getDataObject(dataPropAtom.getArgument2(), binding));
            } else if (atom instanceof SameIndividualAtom) {
                SameIndividualAtom sameAtom = (SameIndividualAtom)atom;
                SameIndividualAtom sameIndividualAtom = swrl.createSameIndividualAtom(this.getIndidividualObject(sameAtom.getArgument1(), binding), this.getIndidividualObject(sameAtom.getArgument2(), binding));
            } else if (atom instanceof DifferentIndividualsAtom) {
                DifferentIndividualsAtom diffAtom = (DifferentIndividualsAtom)atom;
                DifferentIndividualsAtom differentIndividualsAtom = swrl.createDifferentIndividualsAtom(this.getIndidividualObject(diffAtom.getArgument1(), binding), this.getIndidividualObject(diffAtom.getArgument2(), binding));
            } else {
                if (!(atom instanceof BuiltinAtom)) throw new RuntimeException("Unknown atom type " + atom);
                BuiltinAtom builtinAtom = (BuiltinAtom)atom;
                OWLIndividual builtin = builtinAtom.getBuiltin();
                SWRLDataObject arg1 = this.getDataObject((SWRLDataObject)atom.getArgument(0), binding);
                SWRLDataObject arg2 = this.getDataObject((SWRLDataObject)atom.getArgument(1), binding);
                if (builtin.equals(SWRLB.equal)) {
                    BuiltinAtom builtinAtom2 = swrl.createEqual(arg1, arg2);
                } else if (builtin.equals(SWRLB.notEqual)) {
                    BuiltinAtom builtinAtom3 = swrl.createNotEqual(arg1, arg2);
                } else if (builtin.equals(SWRLB.greaterThan)) {
                    BuiltinAtom builtinAtom4 = swrl.createGreaterThan(arg1, arg2);
                } else if (builtin.equals(SWRLB.greaterThanOrEqual)) {
                    BuiltinAtom builtinAtom5 = swrl.createGreaterThanOrEqual(arg1, arg2);
                } else if (builtin.equals(SWRLB.lessThan)) {
                    BuiltinAtom builtinAtom6 = swrl.createLessThan(arg1, arg2);
                } else {
                    if (!builtin.equals(SWRLB.lessThanOrEqual)) throw new NotImplementedException();
                    BuiltinAtom builtinAtom7 = swrl.createLessThanOrEqual(arg1, arg2);
                }
            }
            if (newList.isEmpty()) {
                newList = newList.insert((Atom)var7_9);
            } else {
                newList.add((Atom)var7_9);
            }
            AtomList atomList = (AtomList)var5_6.getRest();
        }
        return newList;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("[");
        RDFList list = this;
        while (!list.isEmpty()) {
            if (list != this) {
                str.append(", ");
            }
            str.append(list.getFirst().toString());
            list = list.getRest();
        }
        str.append("]");
        return str.toString();
    }
}

