/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl;

import java.net.URI;
import java.util.Map;
import org.mindswap.owl.OWLDataValueList;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLWriter;
import org.mindswap.query.ABoxQueryParser;

public class OWLFactory {
    private static String[] implementations = new String[]{"impl.jena.JenaOWLFactory"};
    private static Interface factory = OWLFactory.createFactory();

    private static Interface createFactory() {
        for (int i = 0; factory == null && i < implementations.length; ++i) {
            try {
                Class<?> impl = Class.forName(implementations[i]);
                factory = (Interface)impl.newInstance();
                continue;
            }
            catch (Exception e) {
                System.err.println("Cannot create OWLFactory!");
                e.printStackTrace();
            }
        }
        return factory;
    }

    public static OWLKnowledgeBase createKB() {
        return factory.createKB();
    }

    public static OWLOntology createOntology() {
        return factory.createOntology();
    }

    public static OWLOntology createOntology(URI uri) {
        return factory.createOntology(uri);
    }

    public static OWLReader createReader() {
        return factory.createReader();
    }

    public static OWLWriter createWriter() {
        return factory.createWriter();
    }

    public static OWLDataValueList createDataValueList() {
        return factory.createDataValueList();
    }

    public static OWLIndividualList createIndividualList() {
        return factory.createIndividualList();
    }

    public static Map getReasoners() {
        return factory.getReasoners();
    }

    public static Object getReasoner(String reasonerName) {
        return factory.getReasoner(reasonerName);
    }

    public static ABoxQueryParser createRDQLParser(OWLModel model) {
        return factory.createRDQLParser(model);
    }

    public static Map getDefaultConverters() {
        return factory.getDefaultConverters();
    }

    public static interface Interface {
        public Map getReasoners();

        public Object getReasoner(String var1);

        public OWLKnowledgeBase createKB();

        public OWLOntology createOntology();

        public OWLOntology createOntology(URI var1);

        public OWLReader createReader();

        public OWLWriter createWriter();

        public OWLDataValueList createDataValueList();

        public OWLIndividualList createIndividualList();

        public ABoxQueryParser createRDQLParser(OWLModel var1);

        public Map getDefaultConverters();
    }
}

