/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.generic.expression.Expression;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SameIndividualAtom;
import org.mindswap.swrl.Variable;
import org.mindswap.utils.QNameProvider;

public abstract class BaseExpressionWriter
implements ExpressionWriter {
    protected QNameProvider qnames;
    protected PrintWriter out;
    protected String indent;

    public void setWriter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setWriter(OutputStream out) {
        this.setWriter(new PrintWriter(out));
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setQNames(QNameProvider qnames) {
        this.qnames = qnames;
    }

    public QNameProvider getQNames() {
        return this.qnames;
    }

    public void write(Expression expr, Writer out) {
        boolean noQNameProvider;
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        boolean bl = noQNameProvider = this.qnames == null;
        if (noQNameProvider) {
            this.qnames = expr.getKB().getQNames();
        }
        this.write(expr);
        if (noQNameProvider) {
            this.qnames = null;
        }
    }

    public void write(Expression expr, OutputStream out) {
        this.write(expr, new PrintWriter(out));
    }

    public void write(Expression expr) {
        this.write(expr.getBody());
    }

    public abstract void write(AtomList var1);

    public void write(Atom atom) {
        if (atom instanceof ClassAtom) {
            this.write((ClassAtom)atom);
        } else if (atom instanceof IndividualPropertyAtom) {
            this.write((IndividualPropertyAtom)atom);
        } else if (atom instanceof DataPropertyAtom) {
            this.write((DataPropertyAtom)atom);
        } else if (atom instanceof SameIndividualAtom) {
            this.write((SameIndividualAtom)atom);
        } else if (atom instanceof DifferentIndividualsAtom) {
            this.write((DifferentIndividualsAtom)atom);
        } else if (atom instanceof BuiltinAtom) {
            this.write((BuiltinAtom)atom);
        }
    }

    public abstract void write(ClassAtom var1);

    public abstract void write(IndividualPropertyAtom var1);

    public abstract void write(DataPropertyAtom var1);

    public abstract void write(SameIndividualAtom var1);

    public abstract void write(DifferentIndividualsAtom var1);

    public abstract void write(BuiltinAtom var1);

    public void print(OWLValue value) {
        if (value instanceof Variable) {
            this.out.print("?" + ((Variable)value).getLocalName());
        } else if (value instanceof OWLIndividual) {
            this.print(((OWLIndividual)value).getURI());
        } else {
            this.out.print(value);
        }
    }

    public void print(OWLClass cls) {
        this.print(cls.getURI());
    }

    public void print(OWLProperty prop) {
        this.print(prop.getURI());
    }

    public void print(URI uri) {
        this.out.print(this.qnames.shortForm(uri));
    }
}

