/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.validator;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.exceptions.CastingException;
import org.mindswap.exceptions.ConversionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.AtomicGroundingList;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBinding;
import org.mindswap.owls.process.InputBindingList;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.OutputBindingList;
import org.mindswap.owls.process.OutputList;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.ProcessList;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.ResultList;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.validator.OWLSValidationException;
import org.mindswap.owls.validator.OWLSValidatorMessage;
import org.mindswap.owls.validator.OWLSValidatorReport;
import org.mindswap.owls.vocabulary.OWLS_1_1;

public class OWLSValidator {
    private static final int CODE_INVALID_VALUE = 0;
    private static final int CODE_MISSING_VALUE = 1;
    private Map mMessageMap = new HashMap();
    static /* synthetic */ Class class$org$mindswap$owls$grounding$JavaAtomicGrounding;
    static /* synthetic */ Class class$org$mindswap$owls$grounding$WSDLAtomicGrounding;

    public OWLSValidatorReport validate(OWLOntology theOntology) throws OWLSValidationException {
        OWLKnowledgeBase aKb = OWLFactory.createKB();
        aKb.setReasoner("Pellet");
        aKb.load(theOntology);
        return this.validateKb(aKb);
    }

    public OWLSValidatorReport validate(URI theURI) throws OWLSValidationException {
        return this.validate(theURI.toString());
    }

    public OWLSValidatorReport validate(String theURI) throws OWLSValidationException {
        this.mMessageMap = new HashMap();
        OWLKnowledgeBase aKb = OWLFactory.createKB();
        aKb.setReasoner("Pellet");
        try {
            aKb.read(theURI);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
            throw OWLSValidationException.createParseException("Invalid URI (" + theURI + ") specified for description");
        }
        catch (FileNotFoundException fnfe) {
            throw OWLSValidationException.createFileNotFoundException("File at URI (" + theURI + ") not found, cannot validate");
        }
        catch (Exception ex) {
            throw OWLSValidationException.createParseException("Parse Exception: " + ex.getMessage());
        }
        return this.validateKb(aKb);
    }

    private OWLSValidatorReport validateKb(OWLKnowledgeBase theKb) {
        List aServiceList = theKb.getServices();
        Iterator servIter = aServiceList.iterator();
        while (servIter.hasNext()) {
            Service aService = (Service)servIter.next();
            this.validateService(aService);
        }
        return new OWLSValidatorReport(this.mMessageMap);
    }

    private void validateService(Service theService) {
        if (theService.getProperties(OWLS_1_1.Service.describedBy).size() > 1) {
            OWLSValidatorMessage msg = new OWLSValidatorMessage(0, "Cannot specify more than one describedBy for a service");
            this.addMessage(theService, msg);
        }
        this.validateProfileForService(theService);
        Process aProcess = null;
        try {
            aProcess = theService.getProcess();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateProcess(theService, aProcess);
        this.validateGroundingForService(theService);
    }

    private void validateProcess(Service theService, Process theProcess) {
        OWLSValidatorMessage msg;
        if (theProcess == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No process specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        try {
            if (theProcess.getProfile() == null) {
                msg = new OWLSValidatorMessage(1, "No profile specified for process: " + theProcess.getLocalName());
                this.addMessage(theService, msg);
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        if (theProcess.getNames().size() > 1) {
            msg = new OWLSValidatorMessage(1, "Process '" + theProcess.getLocalName() + "' can specify at most one name");
            this.addMessage(theService, msg);
        }
        ResultList aResultList = theProcess.getResults();
        for (int i = 0; i < aResultList.size(); ++i) {
            Result aResult = aResultList.resultAt(i);
            this.validateResult(theService, aResult);
        }
        ParameterList aParamList = theProcess.getLocals();
        for (int i = 0; i < aParamList.size(); ++i) {
            Local aLocal = (Local)aParamList.parameterAt(i);
            this.validateLocal(theService, aLocal);
        }
        InputList aInputList = theProcess.getInputs();
        for (int i = 0; i < aParamList.size(); ++i) {
            Input aInput = aInputList.inputAt(i);
            this.validateInput(theService, aInput);
        }
        OutputList aOutputList = theProcess.getOutputs();
        for (int i = 0; i < aOutputList.size(); ++i) {
            Output aOutput = aOutputList.outputAt(i);
            this.validateOutput(theService, aOutput);
        }
        if (theProcess.canCastTo(CompositeProcess.class)) {
            this.validateCompositeProcess((CompositeProcess)theProcess.castTo(CompositeProcess.class));
        } else if (theProcess.canCastTo(AtomicProcess.class)) {
            this.validateAtomicProcess((AtomicProcess)theProcess.castTo(AtomicProcess.class));
        } else {
            System.err.println("WTF!");
        }
    }

    private void validateLocal(Service theService, Local theLocal) {
        this.validateParameter(theService, theLocal);
    }

    private void validateInput(Service theService, Input theInput) {
        this.validateParameter(theService, theInput);
    }

    private void validateOutput(Service theService, Output theOutput) {
        this.validateParameter(theService, theOutput);
    }

    private void validateParameter(Service theService, Parameter theParam) {
        OWLSValidatorMessage msg;
        if (theParam.getParamType() == null) {
            msg = new OWLSValidatorMessage(1, "A paramType must be specified for Parameter: " + theParam.getLocalName());
            this.addMessage(theService, msg);
        }
        if (!theParam.getParamType().isDataType()) {
            msg = new OWLSValidatorMessage(0, "The paramType for parameter: '" + theParam.getLocalName() + "' is not specified properly.  It is supposed to be a datatype property, but it is specifed as an Object property.  Please change the declaration.");
            this.addMessage(theService, msg);
        }
    }

    private void validateAtomicProcess(AtomicProcess theAtomicProcess) {
    }

    private void validateCompositeProcess(CompositeProcess theCompositeProcess) {
        Service aService = theCompositeProcess.getService();
        if (theCompositeProcess.getComposedOf() == null) {
            OWLSValidatorMessage msg = new OWLSValidatorMessage(1, "");
            this.addMessage(theCompositeProcess.getService(), msg);
        }
        ControlConstruct aCC = theCompositeProcess.getComposedOf();
        List aList = aCC.getConstructs();
        for (int i = 0; i < aList.size(); ++i) {
            ControlConstruct tempCC = (ControlConstruct)aList.get(i);
            this.validateControlConstruct(aService, tempCC);
        }
        try {
            ProcessList aProcessList = aCC.getAllProcesses();
            for (int i = 0; i < aProcessList.size(); ++i) {
                Process aProcess = aProcessList.processAt(i);
            }
        }
        catch (ConversionException ce) {
            this.addMessage(aService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(aService, 0, ex.getMessage());
        }
    }

    private void validateGroundingForService(Service theService) {
        OWLSValidatorMessage msg;
        Grounding aGrounding = null;
        try {
            aGrounding = theService.getGrounding();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (aGrounding == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No grounding specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aGrounding.getProperties(OWLS_1_1.Service.supportedBy).size() > 1) {
            msg = new OWLSValidatorMessage(0, "The grounding '" + aGrounding.getLocalName() + "' cannot have more than one supportedBy property");
            this.addMessage(theService, msg);
        }
        if (aGrounding.getService() == null) {
            msg = new OWLSValidatorMessage(1, "The grounding '" + aGrounding.getLocalName() + "' does not specify a service.");
            this.addMessage(theService, msg);
        }
        try {
            AtomicGroundingList aGroundingList = aGrounding.getAtomicGroundings();
            for (int i = 0; i < aGroundingList.size(); ++i) {
                AtomicGrounding aAtomicGrounding = aGroundingList.groundingAt(i);
                if (aAtomicGrounding.getProcess() == null) {
                    OWLSValidatorMessage msg3 = new OWLSValidatorMessage(1, "The atomic grounding '" + aAtomicGrounding.getLocalName() + "' does not specify its process.");
                    this.addMessage(theService, msg3);
                }
                if (aAtomicGrounding.canCastTo(class$org$mindswap$owls$grounding$JavaAtomicGrounding == null ? OWLSValidator.class$("org.mindswap.owls.grounding.JavaAtomicGrounding") : class$org$mindswap$owls$grounding$JavaAtomicGrounding) || !aAtomicGrounding.canCastTo(class$org$mindswap$owls$grounding$WSDLAtomicGrounding == null ? OWLSValidator.class$("org.mindswap.owls.grounding.WSDLAtomicGrounding") : class$org$mindswap$owls$grounding$WSDLAtomicGrounding)) continue;
                this.validateWSDLAtomicGrounding(theService, (WSDLAtomicGrounding)aAtomicGrounding.castTo(class$org$mindswap$owls$grounding$WSDLAtomicGrounding == null ? OWLSValidator.class$("org.mindswap.owls.grounding.WSDLAtomicGrounding") : class$org$mindswap$owls$grounding$WSDLAtomicGrounding));
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
    }

    private void validateWSDLAtomicGrounding(Service theService, WSDLAtomicGrounding theWSDLAtomicGrounding) {
        if (theWSDLAtomicGrounding.getOperationRef() == null) {
            this.addMessage(theService, 0, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' has a missing, or invalid operationRef.");
        } else {
            if (theWSDLAtomicGrounding.getOperationRef().getPortType() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify a portType for its operationRef.");
            }
            if (theWSDLAtomicGrounding.getOperationRef().getOperation() == null) {
                this.addMessage(theService, 1, "The grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify an operation for its operationRef");
            }
        }
        MessageMapList inputMap = theWSDLAtomicGrounding.getInputMap();
        for (int i = 0; i < inputMap.size(); ++i) {
            MessageMap aMap = inputMap.messageMapAt(i);
            if (aMap.getGroundingParameter() == null) {
                this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires a grounding parameter (wsdlMessagePart).");
            }
            if (aMap.getOWLSParameter() != null || aMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The input map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an owlsParameter or an xlstTransformation.");
        }
        MessageMapList outputMap = theWSDLAtomicGrounding.getOutputMap();
        for (int i = 0; i < outputMap.size(); ++i) {
            MessageMap aMap = outputMap.messageMapAt(i);
            if (aMap.getOWLSParameter() == null) {
                this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' requires an owlsParameter.");
            }
            if (aMap.getGroundingParameter() != null || aMap.getTransformation() != null) continue;
            this.addMessage(theService, 1, "The output map for grounding '" + theWSDLAtomicGrounding.getLocalName() + "' must specify either an grounding parameter (wsdlMessagePart) or an xlstTransformation.");
        }
    }

    private void validateSplitJoin(Service theService, SplitJoin theSplitJoin) {
        ControlConstructBag ccBag = theSplitJoin.getComponents();
        for (int i = 0; i < ccBag.size(); ++i) {
            ControlConstruct aCC = ccBag.constructAt(i);
            this.validateControlConstruct(theService, aCC);
        }
    }

    private void validateControlConstruct(Service theService, ControlConstruct theControlConstruct) {
        if (theControlConstruct.canCastTo(Perform.class)) {
            this.validatePerform(theService, (Perform)theControlConstruct.castTo(Perform.class));
        } else if (theControlConstruct.canCastTo(SplitJoin.class)) {
            this.validateSplitJoin(theService, (SplitJoin)theControlConstruct.castTo(SplitJoin.class));
        } else {
            System.err.println("unsupported CC? " + theControlConstruct.getClass());
        }
    }

    private void validateResult(Service theService, Result theResult) {
        ParameterList aParamList = theResult.getParameters();
        for (int i = 0; i < aParamList.size(); ++i) {
            Parameter aParam = aParamList.parameterAt(i);
            this.validateParameter(theService, aParam);
        }
        OWLIndividualList aList = theResult.getEffects();
        for (int i = 0; i < aList.size(); ++i) {
            OWLIndividual aInd = aList.individualAt(i);
        }
        OutputBindingList aBindingList = theResult.getBindings();
        for (int i = 0; i < aBindingList.size(); ++i) {
            OutputBinding aOutputBinding = aBindingList.outputBindingAt(i);
            if (aOutputBinding.getOutput() != null) continue;
            this.addMessage(theService, 1, "Result '" + theResult.getLocalName() + "' must specify an Output for its toParam property.");
        }
    }

    private void validatePerform(Service theService, Perform thePerform) {
        try {
            if (thePerform.getProcess() == null) {
                OWLSValidatorMessage msg = new OWLSValidatorMessage(1, "Perform '" + thePerform.getLocalName() + "' must specify a process");
                this.addMessage(theService, msg);
            }
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        InputBindingList aBindingList = thePerform.getBindings();
        for (int i = 0; i < aBindingList.size(); ++i) {
            InputBinding aInputBinding = aBindingList.inputBindingAt(i);
            try {
                if (aInputBinding.getInput() != null) continue;
                this.addMessage(theService, 1, "Perform '" + thePerform.getLocalName() + "' must specify an Input for the toParam property.");
                continue;
            }
            catch (CastingException ex) {
                this.addMessage(theService, 0, ex.getMessage());
                continue;
            }
            catch (ConversionException ex) {
                this.addMessage(theService, 0, ex.getMessage());
            }
        }
    }

    private void validateProfileForService(Service theService) {
        int i;
        OWLSValidatorMessage msg;
        Profile aProfile = null;
        try {
            aProfile = theService.getProfile();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (aProfile == null) {
            OWLSValidatorMessage msg2 = new OWLSValidatorMessage(1, "No profile specified for service: " + theService.getLocalName());
            this.addMessage(theService, msg2);
            return;
        }
        if (aProfile.getService() == null) {
            msg = new OWLSValidatorMessage(1, "No service specified for profile: " + aProfile.getLocalName() + "; double check the presentedBy property on the profile to make sure its correctly specified");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_1.Profile.serviceName).size() != 1) {
            msg = new OWLSValidatorMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one serviceName. ");
            this.addMessage(theService, msg);
        }
        if (aProfile.getProperties(OWLS_1_1.Profile.textDescription).size() != 1) {
            msg = new OWLSValidatorMessage(1, "The profile '" + aProfile.getLocalName() + "' must specify only one textDescription.");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getInputs().equals(theService.getProcess().getInputs())) {
            msg = new OWLSValidatorMessage(0, "Profile inputs for service '" + theService.getLocalName() + "' do not match the process inputs!");
            this.addMessage(theService, msg);
        }
        if (!aProfile.getOutputs().equals(theService.getProcess().getOutputs())) {
            msg = new OWLSValidatorMessage(0, "Profile outputs for service '" + theService.getLocalName() + "' do not match the process outputs!");
            this.addMessage(theService, msg);
        }
        OWLIndividualList aList = aProfile.getServiceParameters();
        for (i = 0; i < aList.size(); ++i) {
            ServiceParameter aServParam = (ServiceParameter)aList.individualAt(i);
            this.validateServiceParameter(theService, aServParam);
        }
        aList = aProfile.getCategories();
        for (i = 0; i < aList.size(); ++i) {
            ServiceCategory aServCategory = (ServiceCategory)aList.individualAt(i);
            this.validateServiceCategory(theService, aServCategory);
        }
        try {
            if (aProfile.getProcess() == null) {
                OWLSValidatorMessage msg3 = new OWLSValidatorMessage(1, "Profile '" + aProfile.getLocalName() + "' do not specify a process!");
                this.addMessage(theService, msg3);
            }
        }
        catch (ConversionException ce) {
            this.addMessage(theService, 0, ce.getMessage());
        }
        catch (CastingException ex) {
            this.addMessage(theService, 0, ex.getMessage());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        ResultList aResultList = aProfile.getResults();
        for (int i2 = 0; i2 < aResultList.size(); ++i2) {
            this.validateResult(theService, aResultList.resultAt(i2));
        }
    }

    private void validateServiceParameter(Service theService, ServiceParameter theServiceParameter) {
        OWLSValidatorMessage msg;
        if (theServiceParameter.getName() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a name for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceParameter.getParameter() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a parameter for serviceParameter: " + theServiceParameter.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void validateServiceCategory(Service theService, ServiceCategory theServiceCategory) {
        OWLSValidatorMessage msg;
        if (theServiceCategory.getCode() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a code for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getValue() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a value for serviceCategory " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getTaxonomy() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a taxonomy for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
        if (theServiceCategory.getName() == null) {
            msg = new OWLSValidatorMessage(1, "Must specify a name for serviceCategory: " + theServiceCategory.getLocalName());
            this.addMessage(theService, msg);
        }
    }

    private void addMessage(Service theService, int theCode, String theMsg) {
        this.addMessage(theService, new OWLSValidatorMessage(theCode, theMsg));
    }

    private void addMessage(Service theService, OWLSValidatorMessage theMsg) {
        HashSet<OWLSValidatorMessage> aSet = (HashSet<OWLSValidatorMessage>)this.mMessageMap.get(theService);
        if (aSet == null) {
            aSet = new HashSet<OWLSValidatorMessage>();
        }
        aSet.add(theMsg);
        this.mMessageMap.put(theService, aSet);
    }

    public static void main(String[] args) {
        System.err.println("validator main");
        OWLSValidator aValidator = new OWLSValidator();
        try {
            new OWLSValidator().validate(new File("composite.owl").toURL().toExternalForm().replaceAll(" ", "%20")).print(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

