/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.swrl.Variable;

public class ABoxQuery {
    private AtomList body;
    private List resultVars;

    public ABoxQuery(AtomList body) {
        this(body, Collections.EMPTY_LIST);
    }

    public ABoxQuery(AtomList body, Collection resultVars) {
        this.body = body;
        this.resultVars = new ArrayList(resultVars);
    }

    public void addResultVar(Variable var) {
        this.resultVars.add(var);
    }

    public void addResultVars(Collection vars) {
        this.resultVars.addAll(vars);
    }

    public AtomList getBody() {
        return this.body;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public List getVars() {
        ArrayList<SWRLObject> vars = new ArrayList<SWRLObject>();
        AtomList list = this.body;
        while (!list.isEmpty()) {
            Atom atom = (Atom)list.getFirst();
            for (int j = 0; j < atom.getArgumentCount(); ++j) {
                SWRLObject term = atom.getArgument(j);
                if (!(term instanceof Variable)) continue;
                vars.add(term);
            }
            list = (AtomList)list.getRest();
        }
        return vars;
    }

    public List run(OWLKnowledgeBase kb) {
        return kb.query(this);
    }

    public ABoxQuery apply(ValueMap binding) {
        AtomList atoms = this.getBody().apply(binding);
        ArrayList newResultVars = new ArrayList(this.resultVars);
        newResultVars.removeAll(binding.getVariables());
        return new ABoxQuery(atoms, newResultVars);
    }

    public String toString() {
        return "query(" + this.getResultVars() + ") :- " + this.getBody().toString();
    }
}

