/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.swrl.Variable;

public class ValueMap {
    private Map map = new HashMap();

    public void setDataValue(Variable var, String value) {
        this.setValue(var, EntityFactory.createDataValue(value));
    }

    public void setValue(Variable var, OWLValue value) {
        if (var == null) {
            throw new NullPointerException("ValueMap cannot set a value for null variable");
        }
        if (value == null) {
            throw new NullPointerException("Value of variable '" + var + "' cannot be set to null");
        }
        this.map.put(var, value);
    }

    public OWLValue getValue(Variable var) {
        return (OWLValue)this.map.get(var);
    }

    public OWLDataValue getDataValue(Variable var) {
        return (OWLDataValue)this.map.get(var);
    }

    public OWLDataValue getDataValue(String var) {
        return (OWLDataValue)this.getValue(var);
    }

    public String getStringValue(Variable var) {
        return this.map.get(var).toString();
    }

    public String getStringValue(String var) {
        return this.getValue(var).toString();
    }

    public OWLIndividual getIndividualValue(Variable var) {
        return (OWLIndividual)this.map.get(var);
    }

    public OWLIndividual getIndividualValue(String var) {
        return (OWLIndividual)this.getValue(var);
    }

    public OWLValue getValue(String varName) {
        Iterator i = this.getVariables().iterator();
        while (i.hasNext()) {
            Variable var = (Variable)i.next();
            if (var.isAnon() || !var.getLocalName().equals(varName)) continue;
            return this.getValue(var);
        }
        return null;
    }

    public boolean hasValue(Variable var) {
        return this.map.containsKey(var);
    }

    public void clearValue(Variable var) {
        this.map.remove(var);
    }

    public void clear() {
        this.map.clear();
    }

    public void addMap(ValueMap valueMap) {
        this.map.putAll(valueMap.map);
    }

    public Set getVariables() {
        return this.map.keySet();
    }

    public Collection getValues() {
        return this.map.values();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public String debugString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.getVariables().iterator();
        while (i.hasNext()) {
            Variable var = (Variable)i.next();
            OWLValue val = this.getValue(var);
            String value = val.isDataValue() ? val.toString() : ((OWLIndividual)val).toRDF(false);
            sb.append("(");
            sb.append(var.getURI());
            sb.append("=");
            sb.append(value);
            sb.append(")");
            if (!i.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }
}

