/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ConditionList;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Process;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.swrl.SWRLIndividualObject;

public class ProcessUtils {
    static /* synthetic */ Class class$org$mindswap$swrl$SWRLIndividualObject;

    public static Map getAllowedValues(Process process) {
        return ProcessUtils.getAllowedValues(process.getKB(), process, new ValueMap());
    }

    public static Map getAllowedValues(Process process, ValueMap initialBinding) {
        return ProcessUtils.getAllowedValues(process.getKB(), process, initialBinding);
    }

    public static Map getAllowedValues(OWLKnowledgeBase kb, Process process, ValueMap initialBinding) {
        SWRLFactory swrl = SWRLFactoryCreator.createFactory(process.getOntology());
        HashMap allowedValues = new HashMap();
        ConditionList conditions = process.getConditions();
        if (conditions.size() > 1) {
            System.err.println("getAllowedValues does not support for multiple conditions, checking the first condition only!");
        }
        AtomList atoms = null;
        if (conditions.isEmpty()) {
            swrl = SWRLFactoryCreator.createFactory(kb.getBaseOntology());
            atoms = swrl.createList();
        } else {
            Condition condition = conditions.conditionAt(0);
            atoms = condition.getBody().apply(initialBinding);
            swrl = SWRLFactoryCreator.createFactory(process.getOntology());
        }
        InputList inputs = process.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            Input input = inputs.inputAt(i);
            OWLType inputType = input.getParamType();
            if (initialBinding.hasValue(input)) continue;
            allowedValues.put(input, new HashSet());
            if (!inputType.isClass()) continue;
            ClassAtom typeAtom = swrl.createClassAtom((OWLClass)inputType, (SWRLIndividualObject)input.castTo(class$org$mindswap$swrl$SWRLIndividualObject == null ? ProcessUtils.class$("org.mindswap.swrl.SWRLIndividualObject") : class$org$mindswap$swrl$SWRLIndividualObject));
            atoms = atoms.insert(typeAtom);
        }
        ABoxQuery query = new ABoxQuery(atoms);
        query.addResultVars(allowedValues.keySet());
        System.out.println(query);
        List results = kb.query(query);
        Iterator i = results.iterator();
        while (i.hasNext()) {
            ValueMap binding = (ValueMap)i.next();
            Iterator j = allowedValues.keySet().iterator();
            while (j.hasNext()) {
                Input input = (Input)j.next();
                OWLValue value = binding.getValue(input);
                if (value == null) continue;
                Set set = (Set)allowedValues.get(input);
                set.add(value);
            }
        }
        return allowedValues;
    }
}

