/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.StringReader;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.RDF;

public class RDFUtils {
    public static String addRDFTag(String rdf) {
        return "<rdf:RDF xmlns:rdf=\"" + RDF.getURI() + "\">" + rdf + "</rdf:RDF>";
    }

    public static String removeRDFTag(String rdf) {
        int rdfTagBegin = rdf.indexOf("<rdf:RDF");
        int rdfTagEnd = rdf.indexOf(">", rdfTagBegin + 1);
        int rdfEndTag = rdf.indexOf("</rdf:RDF>");
        rdf = rdf.substring(rdfTagEnd + 1, rdfEndTag);
        return rdf;
    }

    public static String removeRDFTag(String rdf, boolean keepNamespaces) {
        int rdfTagBegin = rdf.indexOf("<rdf:RDF");
        int rdfTagEnd = rdf.indexOf(">", rdfTagBegin + 1);
        int rdfEndTag = rdf.indexOf("</rdf:RDF>");
        if (keepNamespaces) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(rdf.substring(0, rdfTagEnd + 1));
            buffer.append("<rdf:Description><rdfs:label rdf:parseType=\"Literal\">");
            buffer.append(rdf.substring(rdfTagEnd + 1, rdfEndTag));
            buffer.append("</rdfs:label></rdf:Description>");
            buffer.append(rdf.substring(rdfEndTag));
            OWLKnowledgeBase kb = OWLFactory.createKB();
            OWLOntology ont = kb.read(new StringReader(buffer.toString()), null);
            OWLIndividual ind = ont.getIndividuals().individualAt(0);
            rdf = ind.getLabel();
        } else {
            rdf = rdf.substring(rdfTagEnd + 1, rdfEndTag);
        }
        return rdf;
    }
}

