/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.client.Call;
import org.apache.axis.enum.Style;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.mindswap.utils.URIUtils;
import org.mindswap.wsdl.WSDLConsts;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLOperation {
    public static boolean DEBUG = false;
    private WSDLService service = null;
    private Call call = null;
    private Vector inputs = new Vector();
    private Vector outputs = new Vector();
    private String operationName;
    private String inputMessageName;
    private String outputMessageName;
    private String portName;
    private String documentation;

    public WSDLOperation(Call c) {
        this.call = c;
    }

    public WSDLParameter getInput(int i) {
        return (WSDLParameter)this.getInputs().elementAt(i);
    }

    public WSDLParameter getInput(String name) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            WSDLParameter in = (WSDLParameter)this.inputs.get(i);
            String paramName = in.getName();
            if (!paramName.equals(name) && !URIUtils.getLocalName(paramName).equals(name)) continue;
            return in;
        }
        return null;
    }

    public WSDLParameter getOutput(int i) {
        return (WSDLParameter)this.getOutputs().elementAt(i);
    }

    public WSDLParameter getOutput(String name) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            WSDLParameter out = (WSDLParameter)this.outputs.get(i);
            String paramName = out.getName();
            if (!URIUtils.relaxedMatch(paramName, name)) continue;
            return out;
        }
        return null;
    }

    public Vector getInputs() {
        return this.inputs;
    }

    public Vector getOutputs() {
        return this.outputs;
    }

    void addInput(String name, QName type) {
        this.inputs.add(new WSDLParameter(name, type));
    }

    void addOutput(String name, QName type) {
        this.outputs.add(new WSDLParameter(name, type));
    }

    public String getName() {
        return this.call.getOperationName().getLocalPart();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String s) {
        this.operationName = s;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String s) {
        this.portName = s;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public void setInputMessageName(String s) {
        this.inputMessageName = s;
    }

    public String getOutputMessageName() {
        return this.outputMessageName;
    }

    public void setOutputMessageName(String s) {
        this.outputMessageName = s;
    }

    public WSDLService getService() {
        return this.service;
    }

    public void setService(WSDLService s) {
        this.service = s;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String s) {
        this.documentation = s;
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        WSDLParameter param;
        String s = this.getName() + "(";
        Iterator i = this.inputs.iterator();
        while (i.hasNext()) {
            param = (WSDLParameter)i.next();
            s = s + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ") -> (";
        i = this.outputs.iterator();
        while (i.hasNext()) {
            param = (WSDLParameter)i.next();
            s = s + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    public void invoke() throws Exception {
        SOAPEnvelope request = this.createRequest();
        if (DEBUG) {
            System.out.println("Invoke operation " + this.getDescription());
            System.out.println(request);
        }
        SOAPEnvelope reply = this.call.invoke(request);
        if (DEBUG) {
            System.out.println(reply);
        }
        this.processResult(reply);
    }

    private void processResult(SOAPEnvelope reply) throws SOAPException {
        SOAPBody soapBody = reply.getBody();
        SOAPElement response = (SOAPElement)soapBody.getChildElements().next();
        Iterator messageParts = response.getChildElements();
        for (int i = 0; i < this.outputs.size(); ++i) {
            SOAPElement e = (SOAPElement)messageParts.next();
            if (DEBUG) {
                System.out.println("processResult " + e);
                System.out.println("getValue " + e.getValue());
                System.out.println("getValue is null? " + (e.getValue() == null));
                System.out.println("result has children? " + e.getChildElements().hasNext());
                if (e.getChildElements().hasNext()) {
                    System.out.println("result first child " + e.getChildElements().next());
                }
            }
            WSDLParameter output = (WSDLParameter)this.outputs.elementAt(0);
            output.setTextValue(e.toString());
            if (e.getValue() != null) {
                output.setValue(e.getValue());
                continue;
            }
            output.setValue(e.toString());
        }
    }

    private SOAPEnvelope createRequest() throws SOAPException {
        String targetNamespace = this.call.getOperationName().getNamespaceURI();
        String opName = this.call.getOperationName().getLocalPart();
        SOAPEnvelope envelope = new SOAPEnvelope();
        if (DEBUG) {
            System.out.println("SOAP Action = " + this.call.getSOAPActionURI());
            System.out.println("SOAP Action used = " + this.call.useSOAPAction());
        }
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        String inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (inputEncodingStyle != null) {
            envelope.setEncodingStyle(inputEncodingStyle);
            envelope.addAttribute("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle", inputEncodingStyle);
        }
        String nsOp = this.call.getOperationStyle().equals(Style.RPC) ? "u" : "";
        SOAPBodyElement soapBody = new SOAPBodyElement(envelope.createName(opName, nsOp, targetNamespace));
        envelope.addBodyElement(soapBody);
        Iterator i = this.inputs.iterator();
        while (i.hasNext()) {
            WSDLParameter param = (WSDLParameter)i.next();
            Object paramValue = param.getValue();
            if (paramValue == null) continue;
            SOAPElement soapElement = soapBody.addChildElement(URIUtils.getLocalName(param.getName()), "");
            if (paramValue instanceof Node) {
                if (DEBUG) {
                    System.out.println("Case 1");
                }
                this.createSOAPElement(soapElement, (Node)paramValue);
                if (soapElement.getAttributeValue((Name)WSDLConsts.xsiType) != null) continue;
                if (DEBUG) {
                    System.out.println("Case 1a");
                }
                soapElement.addAttribute((Name)WSDLConsts.xsiType, "u:" + param.getType().getLocalPart());
                continue;
            }
            if (DEBUG) {
                System.out.println("Case 2 " + param.getType());
            }
            soapElement.addAttribute((Name)WSDLConsts.xsiType, "xsd:" + param.getType().getLocalPart());
            soapElement.addTextNode(paramValue.toString());
        }
        return envelope;
    }

    public void createSOAPElement(SOAPElement parent, Node node) throws SOAPException {
        short type = node.getNodeType();
        if (type == 3) {
            if (DEBUG) {
                System.out.println("Case 3");
            }
            parent.addAttribute((Name)WSDLConsts.xsiType, "xsd:string");
            parent.addTextNode(node.getNodeValue());
        } else if (type == 1) {
            SOAPElement soapElement;
            if (!(node.getParentNode() instanceof Document)) {
                if (DEBUG) {
                    System.out.println("Case 4");
                }
                soapElement = parent.addChildElement(node.getNodeName());
            } else {
                if (DEBUG) {
                    System.out.println("Case 5");
                }
                soapElement = parent;
            }
            NodeList children = node.getChildNodes();
            if (children != null) {
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.createSOAPElement(soapElement, children.item(i));
                }
            }
        }
    }
}

