/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLType;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.URIUtils;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;

public class WSDLTranslator {
    private Service service;
    private OWLOntology ont = OWLFactory.createOntology();
    URI baseURI;

    public WSDLTranslator(WSDLOperation op, String serviceURI, String prefix) {
        this.baseURI = URIUtils.createURI(serviceURI);
        this.service = this.ont.createService(URIUtils.createURI(this.baseURI, prefix + "Service"));
        Profile profile = this.ont.createProfile(URIUtils.createURI(this.baseURI, prefix + "Profile"));
        AtomicProcess process = this.ont.createAtomicProcess(URIUtils.createURI(this.baseURI, prefix + "Process"));
        Grounding grounding = this.ont.createGrounding(URIUtils.createURI(this.baseURI, prefix + "Grounding"));
        WSDLAtomicGrounding ag = this.ont.createWSDLAtomicGrounding(URIUtils.createURI(this.baseURI, prefix + "AtomicProcessGrounding"));
        process.setLabel(process.getURI().getFragment());
        this.service.setProfile(profile);
        this.service.setProcess(process);
        this.service.setGrounding(grounding);
        ag.setProcess(process);
        ag.setOperation(URI.create(op.getOperationName()));
        ag.setWSDL(op.getService().getFileURI());
        ag.setPortType(URI.create(op.getPortName()));
        ag.setInputMessage(URI.create(op.getInputMessageName()));
        ag.setOutputMessage(URI.create(op.getOutputMessageName()));
        grounding.addGrounding(ag);
    }

    public void setServiceName(String serviceName) {
        this.service.getProfile().setServiceName(serviceName);
    }

    public void setTextDescription(String textDescription) {
        this.service.getProfile().setTextDescription(textDescription);
        System.out.println(this.service.getProfile().getTextDescription());
    }

    public void addInput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Profile profile = this.service.getProfile();
        AtomicProcess process = (AtomicProcess)this.service.getProcess();
        Input input = this.ont.createInput(URIUtils.createURI(this.baseURI, paramName));
        input.setLabel(paramName);
        OWLType type = this.ont.getType(paramType);
        input.setParamType(type == null ? this.ont.createClass(paramType) : type);
        process.addInput(input);
        profile.addInput(input);
        AtomicGrounding grounding = process.getGrounding();
        grounding.addMessageMap(input, param.getName(), xsltTransformation);
    }

    public void addOutput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Profile profile = this.service.getProfile();
        AtomicProcess process = (AtomicProcess)this.service.getProcess();
        Output output = this.ont.createOutput(URIUtils.createURI(this.baseURI, paramName));
        output.setLabel(paramName);
        OWLType type = this.ont.getType(paramType);
        output.setParamType(type == null ? this.ont.createClass(paramType) : type);
        process.addOutput(output);
        profile.addOutput(output);
        AtomicGrounding grounding = process.getGrounding();
        grounding.addMessageMap(output, param.getName(), xsltTransformation);
    }

    public void writeOWLS(Writer out) {
        this.ont.write(out, this.baseURI);
    }
}

