/*
 * Decompiled with CFR 0.152.
 */
package org.owlet.helpers;

public class ReflectionHelpers {
    public static Object getCastedObjectFromStringValue(String lexicalValue, Class type) {
        String strClass = type.getName();
        Integer retVal = null;
        if ("short".equals(strClass) || "java.lang.Short".equals(strClass)) {
            return new Short(lexicalValue);
        }
        if ("byte".equals(strClass) || "java.lang.Byte".equals(strClass)) {
            return new Byte(lexicalValue);
        }
        if ("int".equals(strClass) || "java.lang.Integer".equals(strClass)) {
            retVal = new Integer(lexicalValue);
        } else {
            if ("long".equals(strClass) || "java.lang.Long".equals(strClass)) {
                return new Long(lexicalValue);
            }
            if ("float".equals(strClass) || "java.lang.Float".equals(strClass)) {
                return new Float(lexicalValue);
            }
            if ("double".equals(strClass) || "java.lang.Double".equals(strClass)) {
                return new Double(lexicalValue);
            }
            if ("char".equals(strClass) || "java.lang.Character".equals(strClass)) {
                return new Character(lexicalValue.charAt(0));
            }
            if ("boolean".equals(strClass) || "java.lang.Boolean".equals(strClass)) {
                return new Boolean(lexicalValue);
            }
        }
        return retVal;
    }

    public static Class getClassFromString(String strClass) {
        Class<?> javaClass = null;
        if ("short".equals(strClass)) {
            return Short.TYPE;
        }
        if ("byte".equals(strClass)) {
            return Byte.TYPE;
        }
        if ("int".equals(strClass)) {
            return Integer.TYPE;
        }
        if ("long".equals(strClass)) {
            return Long.TYPE;
        }
        if ("float".equals(strClass)) {
            return Float.TYPE;
        }
        if ("double".equals(strClass)) {
            return Double.TYPE;
        }
        if ("char".equals(strClass)) {
            return Character.TYPE;
        }
        if ("boolean".equals(strClass)) {
            return Boolean.TYPE;
        }
        try {
            javaClass = Class.forName(strClass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return javaClass;
    }
}

