/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.ActionList;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.ServiceStateTable;
import com.fujitsu.fla.upnp.StateVariable;
import com.fujitsu.fla.upnp.UPnP;
import com.fujitsu.fla.upnp.control.ActionListener;
import com.fujitsu.fla.upnp.control.QueryListener;
import com.fujitsu.fla.upnp.device.ST;
import com.fujitsu.fla.upnp.event.NotifyRequest;
import com.fujitsu.fla.upnp.event.Subscriber;
import com.fujitsu.fla.upnp.event.SubscriberList;
import com.fujitsu.fla.upnp.http.HTTP;
import com.fujitsu.fla.upnp.http.HTTPResponse;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifyRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifySocket;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import com.fujitsu.fla.upnp.util.Mutex;
import com.fujitsu.fla.upnp.util.StringUtil;
import com.fujitsu.fla.upnp.xml.Node;
import com.fujitsu.fla.upnp.xml.Parser;
import com.fujitsu.fla.upnp.xml.ParserException;
import com.fujitsu.fla.upnp.xml.ServiceData;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Service {
    public static final String ELEM_NAME = "service";
    private Mutex mutex = new Mutex();
    private static final String SERVICE_TYPE = "serviceType";
    private static final String SERVICE_ID = "serviceId";
    private static final String SCPDURL = "SCPDURL";
    private static final String CONTROL_URL = "controlURL";
    private static final String EVENT_SUB_URL = "eventSubURL";
    private Node serviceNode;

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Service(Node node) {
        this.serviceNode = node;
    }

    public void lock() {
        this.mutex.lock();
    }

    public void unlock() {
        this.mutex.unlock();
    }

    public static boolean isServiceNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    private Node getDeviceNode() {
        Node node = this.getServiceNode().getParentNode();
        if (node == null) {
            return null;
        }
        return node.getParentNode();
    }

    private Node getRootNode() {
        return this.getServiceNode().getRootNode();
    }

    public Device getDevice() {
        return new Device(this.getRootNode(), this.getDeviceNode());
    }

    public Device getRootDevice() {
        return this.getDevice().getRootDevice();
    }

    public void setDescriptionURL(String value) {
        this.getServiceData().setDescriptionURL(value);
    }

    public String getDescriptionURL() {
        return this.getServiceData().getDescriptionURL();
    }

    public void setServiceType(String value) {
        this.getServiceNode().setNode(SERVICE_TYPE, value);
    }

    public String getServiceType() {
        return this.getServiceNode().getNodeValue(SERVICE_TYPE);
    }

    public void setServiceID(String value) {
        this.getServiceNode().setNode(SERVICE_ID, value);
    }

    public String getServiceID() {
        return this.getServiceNode().getNodeValue(SERVICE_ID);
    }

    public void setSCPDURL(String value) {
        this.getServiceNode().setNode(SCPDURL, value);
    }

    public String getSCPDURL() {
        return this.getServiceNode().getNodeValue(SCPDURL);
    }

    private boolean isURL(String referenceUrl, String url) {
        if (referenceUrl == null || url == null) {
            return false;
        }
        boolean ret = url.equals(referenceUrl);
        if (ret) {
            return true;
        }
        String relativeRefUrl = HTTP.toRelativeURL(referenceUrl, false);
        ret = url.equals(relativeRefUrl);
        return ret;
    }

    public void setControlURL(String value) {
        this.getServiceNode().setNode(CONTROL_URL, value);
    }

    public String getControlURL() {
        return this.getServiceNode().getNodeValue(CONTROL_URL);
    }

    public boolean isControlURL(String url) {
        return this.isURL(this.getControlURL(), url);
    }

    public void setEventSubURL(String value) {
        this.getServiceNode().setNode(EVENT_SUB_URL, value);
    }

    public String getEventSubURL() {
        return this.getServiceNode().getNodeValue(EVENT_SUB_URL);
    }

    public boolean isEventSubURL(String url) {
        return this.isURL(this.getEventSubURL(), url);
    }

    private Node getSCPDNode(String urlStr) throws MalformedURLException, ParserException {
        URL url = new URL(urlStr);
        Parser parser = UPnP.getXMLParser();
        return parser.parse(url);
    }

    private Node getSCPDNode(File file) throws ParserException {
        Parser parser = UPnP.getXMLParser();
        return parser.parse(file);
    }

    private Node getSCPDNode() {
        Node serviceNode = this.getServiceNode();
        ServiceData data = this.getServiceData();
        Node scpdNode = data.getSCPDNode();
        if (scpdNode != null) {
            return scpdNode;
        }
        String scpdURLStr = this.getSCPDURL();
        try {
            scpdNode = this.getSCPDNode(scpdURLStr);
        }
        catch (Exception e1) {
            Device rootDev = this.getRootDevice();
            String urlBaseStr = rootDev.getURLBase();
            if (urlBaseStr == null || urlBaseStr.length() <= 0) {
                String location = rootDev.getLocation();
                String locationHost = HTTP.getHost(location);
                int locationPort = HTTP.getPort(location);
                urlBaseStr = HTTP.getRequestHostURL(locationHost, locationPort);
            }
            scpdURLStr = HTTP.toRelativeURL(scpdURLStr);
            String newScpdURLStr = String.valueOf(urlBaseStr) + scpdURLStr;
            try {
                scpdNode = this.getSCPDNode(newScpdURLStr);
            }
            catch (Exception e2) {
                newScpdURLStr = HTTP.getAbsoluteURL(urlBaseStr, scpdURLStr);
                try {
                    scpdNode = this.getSCPDNode(newScpdURLStr);
                }
                catch (Exception e3) {
                    newScpdURLStr = String.valueOf(rootDev.getDescriptionFilePath()) + scpdURLStr;
                    try {
                        scpdNode = this.getSCPDNode(new File(newScpdURLStr));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        data.setSCPDNode(scpdNode);
        return scpdNode;
    }

    public ActionList getActionList() {
        ActionList actionList = new ActionList();
        Node scdpNode = this.getSCPDNode();
        if (scdpNode == null) {
            return actionList;
        }
        Node actionListNode = scdpNode.getNode("actionList");
        if (actionListNode == null) {
            return actionList;
        }
        Node serviceNode = this.getServiceNode();
        int nNode = actionListNode.getNNodes();
        int n = 0;
        while (n < nNode) {
            Node node = actionListNode.getNode(n);
            if (Action.isActionNode(node)) {
                Action action = new Action(serviceNode, node);
                actionList.add(action);
            }
            ++n;
        }
        return actionList;
    }

    public Action getAction(String actionName) {
        ActionList actionList = this.getActionList();
        int nActions = actionList.size();
        int n = 0;
        while (n < nActions) {
            Action action = actionList.getAction(n);
            String name = action.getName();
            if (name != null && name.equals(actionName)) {
                return action;
            }
            ++n;
        }
        return null;
    }

    public ServiceStateTable getServiceStateTable() {
        ServiceStateTable stateTable = new ServiceStateTable();
        Node stateTableNode = this.getSCPDNode().getNode("serviceStateTable");
        if (stateTableNode == null) {
            return stateTable;
        }
        Node serviceNode = this.getServiceNode();
        int nNode = stateTableNode.getNNodes();
        int n = 0;
        while (n < nNode) {
            Node node = stateTableNode.getNode(n);
            if (StateVariable.isStateVariableNode(node)) {
                StateVariable serviceVar = new StateVariable(serviceNode, node);
                stateTable.add(serviceVar);
            }
            ++n;
        }
        return stateTable;
    }

    public StateVariable getStateVariable(String name) {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        int n = 0;
        while (n < tableSize) {
            StateVariable var = stateTable.getStateVariable(n);
            String varName = var.getName();
            if (varName != null && varName.equals(name)) {
                return var;
            }
            ++n;
        }
        return null;
    }

    public boolean hasStateVariable(String name) {
        return this.getStateVariable(name) != null;
    }

    public boolean isService(String name) {
        if (name == null) {
            return false;
        }
        if (name.endsWith(this.getServiceType())) {
            return true;
        }
        if (name.endsWith(this.getServiceID())) {
            return true;
        }
        if (this.getServiceType().endsWith(name)) {
            return true;
        }
        return this.getServiceID().endsWith(name);
    }

    private ServiceData getServiceData() {
        Node node = this.getServiceNode();
        ServiceData userData = (ServiceData)node.getUserData();
        if (userData == null) {
            userData = new ServiceData();
            node.setUserData(userData);
            userData.setNode(node);
        }
        return userData;
    }

    private String getNotifyServiceTypeNT() {
        return this.getServiceType();
    }

    private String getNotifyServiceTypeUSN() {
        return String.valueOf(this.getDevice().getUDN()) + "::" + this.getServiceType();
    }

    public void announce(String bindAddr) {
        Device rootDev = this.getRootDevice();
        String devLocation = rootDev.getLocationURL(bindAddr);
        String serviceNT = this.getNotifyServiceTypeNT();
        String serviceUSN = this.getNotifyServiceTypeUSN();
        Device dev = this.getDevice();
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setServer(UPnP.getServerName());
        ssdpReq.setLeaseTime(dev.getLeaseTime());
        ssdpReq.setLocation(devLocation);
        ssdpReq.setNTS("ssdp:alive");
        ssdpReq.setNT(serviceNT);
        ssdpReq.setUSN(serviceUSN);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        Device.notifyWait();
        ssdpSock.post(ssdpReq);
    }

    public void byebye(String bindAddr) {
        String devNT = this.getNotifyServiceTypeNT();
        String devUSN = this.getNotifyServiceTypeUSN();
        SSDPNotifyRequest ssdpReq = new SSDPNotifyRequest();
        ssdpReq.setNTS("ssdp:byebye");
        ssdpReq.setNT(devNT);
        ssdpReq.setUSN(devUSN);
        SSDPNotifySocket ssdpSock = new SSDPNotifySocket(bindAddr);
        Device.notifyWait();
        ssdpSock.post(ssdpReq);
    }

    public boolean serviceSearchResponse(SSDPPacket ssdpPacket) {
        String serviceType;
        String ssdpST = ssdpPacket.getST();
        if (ssdpST == null) {
            return false;
        }
        Device dev = this.getDevice();
        String serviceNT = this.getNotifyServiceTypeNT();
        String serviceUSN = this.getNotifyServiceTypeUSN();
        if (ST.isAllDevice(ssdpST)) {
            dev.postSearchResponse(ssdpPacket, serviceNT, serviceUSN);
        } else if (ST.isURNService(ssdpST) && ssdpST.equals(serviceType = this.getServiceType())) {
            dev.postSearchResponse(ssdpPacket, serviceType, serviceUSN);
        }
        return true;
    }

    public void setQueryListener(QueryListener queryListener) {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        int n = 0;
        while (n < tableSize) {
            StateVariable var = stateTable.getStateVariable(n);
            var.setQueryListener(queryListener);
            ++n;
        }
    }

    public SubscriberList getSubscriberList() {
        return this.getServiceData().getSubscriberList();
    }

    public void addSubscriber(Subscriber sub) {
        this.getSubscriberList().add(sub);
    }

    public void removeSubscriber(Subscriber sub) {
        this.getSubscriberList().remove(sub);
    }

    public Subscriber getSubscriber(String name) {
        SubscriberList subList = this.getSubscriberList();
        int subListCnt = subList.size();
        int n = 0;
        while (n < subListCnt) {
            String sid;
            Subscriber sub = subList.getSubscriber(n);
            if (sub != null && (sid = sub.getSID()) != null && sid.equals(name)) {
                return sub;
            }
            ++n;
        }
        return null;
    }

    private boolean notify(Subscriber sub, StateVariable stateVar) {
        String varName = stateVar.getName();
        String value = stateVar.getValue();
        String host = sub.getDeliveryHost();
        int port = sub.getDeliveryPort();
        String bindAddr = sub.getInterfaceAddress();
        NotifyRequest notifyReq = new NotifyRequest();
        notifyReq.setRequest(sub, varName, value);
        HTTPResponse res = notifyReq.post(host, port);
        if (!res.isSuccessful()) {
            return false;
        }
        sub.incrementNotifyCount();
        return true;
    }

    public void notify(StateVariable stateVar) {
        Subscriber sub;
        SubscriberList subList = this.getSubscriberList();
        int subListCnt = subList.size();
        Subscriber[] subs = new Subscriber[subListCnt];
        int n = 0;
        while (n < subListCnt) {
            subs[n] = subList.getSubscriber(n);
            ++n;
        }
        n = 0;
        while (n < subListCnt) {
            sub = subs[n];
            if (sub.isExpired()) {
                this.removeSubscriber(sub);
            }
            ++n;
        }
        subListCnt = subList.size();
        subs = new Subscriber[subListCnt];
        n = 0;
        while (n < subListCnt) {
            subs[n] = subList.getSubscriber(n);
            ++n;
        }
        n = 0;
        while (n < subListCnt) {
            sub = subs[n];
            this.notify(sub, stateVar);
            ++n;
        }
    }

    public void notifyAllStateVariables() {
        ServiceStateTable stateTable = this.getServiceStateTable();
        int tableSize = stateTable.size();
        int n = 0;
        while (n < tableSize) {
            StateVariable var = stateTable.getStateVariable(n);
            if (var.isSendEvents()) {
                this.notify(var);
            }
            ++n;
        }
    }

    public String getSID() {
        return this.getServiceData().getSID();
    }

    public void setSID(String id) {
        this.getServiceData().setSID(id);
    }

    public void clearSID() {
        this.setSID("");
        this.setTimeout(0L);
    }

    public boolean hasSID() {
        return StringUtil.hasData(this.getSID());
    }

    public boolean isSubscribed() {
        return this.hasSID();
    }

    public long getTimeout() {
        return this.getServiceData().getTimeout();
    }

    public void setTimeout(long value) {
        this.getServiceData().setTimeout(value);
    }

    public void setActionListener(ActionListener listener) {
        ActionList actionList = this.getActionList();
        int nActions = actionList.size();
        int n = 0;
        while (n < nActions) {
            Action action = actionList.getAction(n);
            action.setActionListener(listener);
            ++n;
        }
    }
}

