/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.http;

import com.fujitsu.fla.upnp.http.HTTP;
import com.fujitsu.fla.upnp.http.HTTPPacket;
import com.fujitsu.fla.upnp.http.HTTPResponse;
import com.fujitsu.fla.upnp.http.HTTPSocket;
import java.io.InputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HTTPRequest
extends HTTPPacket {
    private String method = null;
    private String uri = null;
    private String requestHost = "";
    private int requestPort = -1;
    private HTTPSocket httpSocket = null;
    private Socket postSocket = null;

    public HTTPRequest() {
    }

    public HTTPRequest(InputStream in) {
        super(in);
    }

    public HTTPRequest(HTTPSocket httpSock) {
        this(httpSock.getInputStream());
        this.setSocket(httpSock);
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        return this.getFirstLineToken(0);
    }

    public boolean isMethod(String method) {
        String headerMethod = this.getMethod();
        if (headerMethod == null) {
            return false;
        }
        return headerMethod.equalsIgnoreCase(method);
    }

    public boolean isGetRequest() {
        return this.isMethod("GET");
    }

    public boolean isPostRequest() {
        return this.isMethod("POST");
    }

    public boolean isHeadRequest() {
        return this.isMethod("HEAD");
    }

    public boolean isSubscribeRequest() {
        return this.isMethod("SUBSCRIBE");
    }

    public boolean isUnsubscribeRequest() {
        return this.isMethod("UNSUBSCRIBE");
    }

    public boolean isNotifyRequest() {
        return this.isMethod("NOTIFY");
    }

    public void setURI(String value, boolean isCheckRelativeURL) {
        this.uri = value;
        if (!isCheckRelativeURL) {
            return;
        }
        this.uri = HTTP.toRelativeURL(this.uri);
    }

    public void setURI(String value) {
        this.setURI(value, false);
    }

    public String getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        return this.getFirstLineToken(1);
    }

    /*
     * Unable to fully structure code
     */
    public Hashtable getParameterList() {
        paramList = new Hashtable<String, String>();
        uri = this.getURI();
        if (uri == null) {
            return paramList;
        }
        uriLen = uri.length();
        paramIdx = uri.indexOf(63);
        if (paramIdx >= 0) ** GOTO lbl16
        return paramList;
lbl-1000:
        // 1 sources

        {
            eqIdx = uri.indexOf(61, paramIdx + 1);
            name = uri.substring(paramIdx + 1, eqIdx);
            nextParamIdx = uri.indexOf(38, eqIdx + 1);
            value = uri.substring(eqIdx + 1, nextParamIdx > 0 ? nextParamIdx : uri.length());
            paramList.put(name, value);
            paramIdx = nextParamIdx;
lbl16:
            // 2 sources

            ** while (paramIdx > 0)
        }
lbl17:
        // 1 sources

        return paramList;
    }

    public String getParameterValue(String name) {
        Hashtable paramList = this.getParameterList();
        return (String)paramList.get(name);
    }

    public boolean isSOAPAction() {
        return this.hasHeader("SOAPACTION");
    }

    public void setRequestHost(String host) {
        this.requestHost = host;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestPort(int host) {
        this.requestPort = host;
    }

    public int getRequestPort() {
        return this.requestPort;
    }

    public void setSocket(HTTPSocket value) {
        this.httpSocket = value;
    }

    public HTTPSocket getSocket() {
        return this.httpSocket;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    public boolean parseRequestLine(String lineStr) {
        StringTokenizer st = new StringTokenizer(lineStr, " ");
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setMethod(st.nextToken());
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setURI(st.nextToken());
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.setVersion(st.nextToken());
        return true;
    }

    public String getHTTPVersion() {
        if (this.hasFirstLine()) {
            return this.getFirstLineToken(2);
        }
        return "HTTP/" + super.getVersion();
    }

    public String getFirstLineString() {
        return String.valueOf(this.getMethod()) + " " + this.getURI() + " " + this.getHTTPVersion() + "\r\n";
    }

    public String getHeader() {
        StringBuffer str = new StringBuffer();
        str.append(this.getFirstLineString());
        String headerString = this.getHeaderString();
        str.append(headerString);
        return str.toString();
    }

    public boolean isKeepAlive() {
        boolean isHTTP10;
        if (this.isCloseConnection()) {
            return false;
        }
        if (this.isKeepAliveConnection()) {
            return true;
        }
        String httpVer = this.getHTTPVersion();
        boolean bl = isHTTP10 = httpVer.indexOf("1.0") > 0;
        return !isHTTP10;
    }

    public boolean read() {
        return super.read(this.getSocket());
    }

    public boolean post(HTTPResponse httpRes) {
        HTTPSocket httpSock = this.getSocket();
        long offset = 0L;
        long length = httpRes.getContentLength();
        if (this.hasContentRange()) {
            long firstPos = this.getContentRangeFirstPosition();
            long lastPos = this.getContentRangeLastPosition();
            if (lastPos <= 0L) {
                lastPos = length - 1L;
            }
            if (firstPos > length || lastPos > length) {
                return this.returnResponse(416);
            }
            httpRes.setContentRange(firstPos, lastPos, length);
            httpRes.setStatusCode(206);
            offset = firstPos;
            length = lastPos - firstPos + 1L;
        }
        return httpSock.post(httpRes, offset, length, this.isHeadRequest());
    }

    /*
     * Exception decompiling
     */
    public HTTPResponse post(String host, int port, boolean isKeepAlive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [2 : 206->209)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HTTPResponse post(String host, int port) {
        return this.post(host, port, false);
    }

    public void set(HTTPRequest httpReq) {
        this.set((HTTPPacket)httpReq);
        this.setSocket(httpReq.getSocket());
    }

    public boolean returnResponse(int statusCode) {
        HTTPResponse httpRes = new HTTPResponse();
        httpRes.setStatusCode(statusCode);
        httpRes.setContentLength(0L);
        return this.post(httpRes);
    }

    public boolean returnOK() {
        return this.returnResponse(200);
    }

    public boolean returnBadRequest() {
        return this.returnResponse(400);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getHeader());
        str.append("\r\n");
        str.append(this.getContentString());
        return str.toString();
    }

    public void print() {
        System.out.println(this.toString());
    }
}

