/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.http;

import com.fujitsu.fla.upnp.http.HTTP;
import com.fujitsu.fla.upnp.http.HTTPResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class HTTPSocket {
    private Socket socket = null;
    private InputStream sockIn = null;
    private OutputStream sockOut = null;

    public HTTPSocket(Socket socket) {
        this.setSocket(socket);
        this.open();
    }

    public HTTPSocket(HTTPSocket socket) {
        this.setSocket(socket.getSocket());
        this.setInputStream(socket.getInputStream());
        this.setOutputStream(socket.getOutputStream());
    }

    public void finalize() {
        this.close();
    }

    private void setSocket(Socket socket) {
        this.socket = socket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    private void setInputStream(InputStream in) {
        this.sockIn = in;
    }

    public InputStream getInputStream() {
        return this.sockIn;
    }

    private void setOutputStream(OutputStream out) {
        this.sockOut = out;
    }

    private OutputStream getOutputStream() {
        return this.sockOut;
    }

    public boolean open() {
        Socket sock = this.getSocket();
        try {
            this.sockIn = sock.getInputStream();
            this.sockOut = sock.getOutputStream();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            if (this.sockIn != null) {
                this.sockIn.close();
            }
            if (this.sockOut != null) {
                this.sockOut.close();
            }
            this.getSocket().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean post(HTTPResponse httpRes, byte[] content, long contentOffset, long contentLength, boolean isOnlyHeader) {
        httpRes.setDate();
        OutputStream out = this.getOutputStream();
        try {
            httpRes.setContentLength(contentLength);
            out.write(httpRes.getHeader().getBytes());
            out.write("\r\n".getBytes());
            if (isOnlyHeader) {
                out.flush();
                return true;
            }
            out.write(content, (int)contentOffset, (int)contentLength);
            out.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean post(HTTPResponse httpRes, InputStream in, long contentOffset, long contentLength, boolean isOnlyHeader) {
        httpRes.setDate();
        OutputStream out = this.getOutputStream();
        try {
            httpRes.setContentLength(contentLength);
            out.write(httpRes.getHeader().getBytes());
            out.write("\r\n".getBytes());
            if (isOnlyHeader) {
                out.flush();
                return true;
            }
            if (0L < contentOffset) {
                in.skip(contentOffset);
            }
            int chunkSize = HTTP.getChunkSize();
            byte[] readBuf = new byte[chunkSize];
            long readCnt = 0L;
            long readSize = (long)chunkSize < contentLength ? (long)chunkSize : contentLength;
            int readLen = in.read(readBuf, 0, (int)readSize);
            while (readLen > 0 && readCnt < contentLength) {
                out.write(readBuf, 0, readLen);
                readSize = (long)chunkSize < contentLength - (readCnt += (long)readLen) ? (long)chunkSize : contentLength - readCnt;
                readLen = in.read(readBuf, 0, (int)readSize);
            }
            out.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean post(HTTPResponse httpRes, long contentOffset, long contentLength, boolean isOnlyHeader) {
        if (httpRes.hasContentInputStream()) {
            return this.post(httpRes, httpRes.getContentInputStream(), contentOffset, contentLength, isOnlyHeader);
        }
        return this.post(httpRes, httpRes.getContent(), contentOffset, contentLength, isOnlyHeader);
    }
}

