/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.soap;

import com.fujitsu.fla.upnp.http.HTTPResponse;
import com.fujitsu.fla.upnp.soap.SOAP;
import com.fujitsu.fla.upnp.xml.Node;

public class SOAPResponse
extends HTTPResponse {
    private Node rootNode;

    public SOAPResponse() {
        this.setRootNode(SOAP.createEnvelopeBodyNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    public SOAPResponse(HTTPResponse httpRes) {
        super(httpRes);
        this.setRootNode(SOAP.createEnvelopeBodyNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    public SOAPResponse(SOAPResponse soapRes) {
        super(soapRes);
        this.setEnvelopeNode(soapRes.getEnvelopeNode());
        this.setContentType("text/xml; charset=\"utf-8\"");
    }

    private void setRootNode(Node node) {
        this.rootNode = node;
    }

    private Node getRootNode() {
        return this.rootNode;
    }

    public void setEnvelopeNode(Node node) {
        this.setRootNode(node);
    }

    public Node getEnvelopeNode() {
        return this.getRootNode();
    }

    public Node getBodyNode() {
        Node envNode = this.getEnvelopeNode();
        if (envNode == null) {
            return null;
        }
        return envNode.getNodeEndsWith("Body");
    }

    public Node getMethodResponseNode(String name) {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        String methodResName = String.valueOf(name) + "Response";
        return bodyNode.getNodeEndsWith(methodResName);
    }

    public Node getFaultNode() {
        Node bodyNode = this.getBodyNode();
        if (bodyNode == null) {
            return null;
        }
        return bodyNode.getNodeEndsWith("Fault");
    }

    public Node getFaultCodeNode() {
        Node faultNode = this.getFaultNode();
        if (faultNode == null) {
            return null;
        }
        return faultNode.getNodeEndsWith("faultcode");
    }

    public Node getFaultStringNode() {
        Node faultNode = this.getFaultNode();
        if (faultNode == null) {
            return null;
        }
        return faultNode.getNodeEndsWith("faultstring");
    }

    public Node getFaultActorNode() {
        Node faultNode = this.getFaultNode();
        if (faultNode == null) {
            return null;
        }
        return faultNode.getNodeEndsWith("faultactor");
    }

    public Node getFaultDetailNode() {
        Node faultNode = this.getFaultNode();
        if (faultNode == null) {
            return null;
        }
        return faultNode.getNodeEndsWith("detail");
    }

    public String getFaultCode() {
        Node node = this.getFaultCodeNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public String getFaultString() {
        Node node = this.getFaultStringNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public String getFaultActor() {
        Node node = this.getFaultActorNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public void setContent(Node node) {
        String conStr = "";
        conStr = String.valueOf(conStr) + "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        conStr = String.valueOf(conStr) + "\n";
        conStr = String.valueOf(conStr) + node.toString();
        this.setContent(conStr);
    }

    public void print() {
        System.out.println(this.toString());
        if (this.hasContent()) {
            return;
        }
        Node rootElem = this.getRootNode();
        if (rootElem == null) {
            return;
        }
        System.out.println(rootElem.toString());
    }
}

