/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.test;

import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.test.CtrlPoint;
import com.fujitsu.fla.upnp.test.ServiceTable;
import com.fujitsu.fla.upnp.test.TableComp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ServicePane
extends JPanel
implements ActionListener {
    private CtrlPoint ctrlPoint;
    private Service service;
    private ServiceTable serviceTable;
    private JButton subscribeButton;
    private JButton unsubscribeButton;

    public ServicePane(CtrlPoint ctrlPoint, Service service) {
        this.setLayout(new BorderLayout());
        this.ctrlPoint = ctrlPoint;
        this.service = service;
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BorderLayout());
        this.serviceTable = new ServiceTable(service);
        tablePane.add((Component)new TableComp(this.serviceTable), "Center");
        this.add((Component)tablePane, "Center");
        JPanel buttonPane = new JPanel();
        this.subscribeButton = new JButton("Subscribe");
        buttonPane.add(this.subscribeButton);
        this.subscribeButton.addActionListener(this);
        this.unsubscribeButton = new JButton("Unsubscribe");
        buttonPane.add(this.unsubscribeButton);
        this.unsubscribeButton.addActionListener(this);
        this.add((Component)buttonPane, "South");
    }

    private Frame getFrame() {
        return (Frame)this.getRootPane().getParent();
    }

    public Service getService() {
        return this.service;
    }

    public ServiceTable getTable() {
        return this.serviceTable;
    }

    public JButton getButton() {
        return this.subscribeButton;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.subscribeButton) {
            boolean subRes;
            if (this.service.hasSID()) {
                String sid = this.service.getSID();
                subRes = this.ctrlPoint.subscribe(this.service, sid);
            } else {
                subRes = this.ctrlPoint.subscribe(this.service);
            }
            this.ctrlPoint.printConsole("subscribe : " + subRes + " (" + this.service.getSID() + ")");
        } else if (e.getSource() == this.unsubscribeButton) {
            boolean subRes = this.ctrlPoint.unsubscribe(this.service);
            this.ctrlPoint.printConsole("unsubscribe : " + subRes);
        }
    }
}

