/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.util;

public final class StringUtil {
    public static final boolean hasData(String value) {
        if (value == null) {
            return false;
        }
        return value.length() > 0;
    }

    public static final int toInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static final long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static final int findOf(String str, String chars, int startIdx, int endIdx, int offset, boolean isEqual) {
        if (offset == 0) {
            return -1;
        }
        int charCnt = chars.length();
        int idx = startIdx;
        while (!(offset > 0 ? endIdx < idx : idx < endIdx)) {
            char strc = str.charAt(idx);
            int noEqualCnt = 0;
            int n = 0;
            while (n < charCnt) {
                char charc = chars.charAt(n);
                if (isEqual) {
                    if (strc == charc) {
                        return idx;
                    }
                } else {
                    if (strc != charc) {
                        ++noEqualCnt;
                    }
                    if (noEqualCnt == charCnt) {
                        return idx;
                    }
                }
                ++n;
            }
            idx += offset;
        }
        return -1;
    }

    public static final int findFirstOf(String str, String chars) {
        return StringUtil.findOf(str, chars, 0, str.length() - 1, 1, true);
    }

    public static final int findFirstNotOf(String str, String chars) {
        return StringUtil.findOf(str, chars, 0, str.length() - 1, 1, false);
    }

    public static final int findLastOf(String str, String chars) {
        return StringUtil.findOf(str, chars, str.length() - 1, 0, -1, true);
    }

    public static final int findLastNotOf(String str, String chars) {
        return StringUtil.findOf(str, chars, str.length() - 1, 0, -1, false);
    }

    public static final String trim(String trimStr, String trimChars) {
        int spIdx = StringUtil.findFirstNotOf(trimStr, trimChars);
        if (spIdx < 0) {
            String buf = trimStr;
            return buf;
        }
        String trimStr2 = trimStr.substring(spIdx, trimStr.length());
        if ((spIdx = StringUtil.findLastNotOf(trimStr2, trimChars)) < 0) {
            String buf = trimStr2;
            return buf;
        }
        String buf = trimStr2.substring(0, spIdx + 1);
        return buf;
    }
}

