/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.owlapi.PelletVisitor;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeVisitor;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.model.SetOntologyURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletLoader {
    public static Logger log = Logger.getLogger(PelletLoader.class.getName());
    private KnowledgeBase kb;
    private OWLOntologyManager manager;
    private Set<OWLOntology> ontologies;
    private boolean processImports;
    private Set<OWLOntology> notImported;
    private Map<OWLOntology, Set<OWLOntology>> importDependencies;
    private PelletVisitor visitor;
    private ChangeVisitor changeVisitor = new ChangeVisitor();

    public PelletLoader(KnowledgeBase kb) {
        this.kb = kb;
        this.visitor = new PelletVisitor(kb);
        this.processImports = true;
        this.ontologies = new HashSet<OWLOntology>();
        this.notImported = new HashSet<OWLOntology>();
        this.importDependencies = new HashMap<OWLOntology, Set<OWLOntology>>();
    }

    public boolean loadImports() {
        return this.getProcessImports();
    }

    public void setLoadImports(boolean loadImports) {
        this.setProcessImports(loadImports);
    }

    public boolean getProcessImports() {
        return this.processImports;
    }

    public void setProcessImports(boolean processImports) {
        this.processImports = processImports;
    }

    public void clear() {
        this.visitor.clear();
        this.kb.clear();
        this.ontologies.clear();
        this.notImported.clear();
        this.importDependencies.clear();
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    public ATermAppl term(OWLObject d) {
        this.visitor.reset();
        this.visitor.setAddAxiom(false);
        d.accept((OWLObjectVisitor)this.visitor);
        ATermAppl a = this.visitor.result();
        if (a == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + d);
        }
        return a;
    }

    public void reload() {
        log.fine("Reloading the ontologies");
        HashSet<OWLOntology> notImportedOnts = new HashSet<OWLOntology>(this.notImported);
        this.clear();
        this.load(notImportedOnts);
    }

    public void load(Set<OWLOntology> ontologies) {
        Timer timer = this.kb.timers.startTimer("load");
        int axiomCount = 0;
        LinkedHashSet<OWLOntology> toBeLoaded = new LinkedHashSet<OWLOntology>();
        for (OWLOntology ontology : ontologies) {
            axiomCount += this.load(ontology, false, toBeLoaded);
        }
        SilentProgressMonitor monitor = new SilentProgressMonitor();
        monitor.setProgressTitle("Loading");
        monitor.setProgressLength(axiomCount);
        monitor.taskStarted();
        this.visitor.reset();
        this.visitor.setAddAxiom(true);
        this.visitor.setMonitor((ProgressMonitor)monitor);
        for (OWLOntology ontology : toBeLoaded) {
            ontology.accept((OWLObjectVisitor)this.visitor);
        }
        this.visitor.verify();
        monitor.taskFinished();
        timer.stop();
    }

    private int load(OWLOntology ontology, boolean imported, Collection<OWLOntology> toBeLoaded) {
        boolean added;
        if (!imported) {
            this.notImported.add(ontology);
        }
        if (!(added = this.ontologies.add(ontology))) {
            return 0;
        }
        int axiomCount = ontology.getAxioms().size();
        toBeLoaded.add(ontology);
        if (this.processImports) {
            for (OWLOntology importedOnt : ontology.getImports(this.manager)) {
                axiomCount += this.load(importedOnt, true, toBeLoaded);
                Set<OWLOntology> importees = this.importDependencies.get(importedOnt);
                if (importees == null) {
                    importees = new HashSet<OWLOntology>();
                    this.importDependencies.put(importedOnt, importees);
                }
                importees.add(ontology);
            }
        }
        return axiomCount;
    }

    public void unload(Set<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            this.unload(ontology);
        }
    }

    private void unload(OWLOntology ontology) {
        boolean removed = this.ontologies.remove(ontology);
        if (!removed) {
            return;
        }
        this.notImported.remove(ontology);
        if (this.processImports) {
            for (OWLOntology importOnt : ontology.getImports(this.manager)) {
                Set<OWLOntology> importees = this.importDependencies.get(importOnt);
                if (importees == null) continue;
                importees.remove(ontology);
                if (!importees.isEmpty()) continue;
                this.importDependencies.remove(importOnt);
                if (this.notImported.contains(importOnt)) continue;
                this.unload(importOnt);
            }
        }
    }

    public Set<OWLOntology> getOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public Set<OWLAxiom> getUnsupportedAxioms() {
        return this.visitor.getUnsupportedAxioms();
    }

    public boolean applyChanges(List<? extends OWLOntologyChange> changes) {
        this.visitor.reset();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology())) continue;
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)this.changeVisitor);
            if (!this.visitor.isReloadRequired()) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            if (axiom instanceof OWLClassAxiom) {
                log.fine("Removal failed for " + axiom);
            }
            return false;
        }
        return true;
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private ChangeVisitor() {
        }

        public void visit(AddAxiom change) {
            PelletLoader.this.visitor.setAddAxiom(true);
            change.getAxiom().accept((OWLObjectVisitor)PelletLoader.this.visitor);
        }

        public void visit(RemoveAxiom change) {
            PelletLoader.this.visitor.setAddAxiom(false);
            change.getAxiom().accept((OWLObjectVisitor)PelletLoader.this.visitor);
        }

        public void visit(SetOntologyURI change) {
        }
    }
}

