/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.FileDictionaryElementFactory;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.FileBackedDictionary;
import net.didion.jwnl.dictionary.file.DictionaryCatalogSet;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.RandomAccessDictionaryFile;

public class AddReverseEntailment {
    private static final String USAGE = "java AddReverseEntailment <properties file> <dictionary path> <new verb index filename> <new verb data filename>";
    private String path;
    private String verbIdxName;
    private String verbDatName;
    static /* synthetic */ Class class$net$didion$jwnl$princeton$file$PrincetonRandomAccessDictionaryFile;

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println(USAGE);
        }
        String props = args[0];
        String path = args[1];
        String verbIdxName = args[2];
        String verbDatName = args[3];
        try {
            JWNL.initialize((InputStream)new FileInputStream(props));
            new AddReverseEntailment(path, verbIdxName, verbDatName).run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public AddReverseEntailment(String path, String verbIdxName, String verbDatName) {
        this.path = path;
        this.verbIdxName = verbIdxName;
        this.verbDatName = verbDatName;
    }

    private void run() {
        try {
            HashMap entailedByMap = new HashMap();
            HashMap<Long, String> offsetMap = new HashMap<Long, String>();
            long lineNum = 0L;
            Iterator itr = Dictionary.getInstance().getSynsetIterator(POS.VERB);
            while (itr.hasNext()) {
                Synset synset = (Synset)itr.next();
                long sourceOffset = synset.getOffset();
                offsetMap.put(new Long(sourceOffset), "");
                Pointer[] pointers = synset.getPointers(PointerType.ENTAILMENT);
                for (int i = 0; i < pointers.length; ++i) {
                    this.add(pointers[i].getTargetOffset(), sourceOffset, entailedByMap);
                }
                if (lineNum % 1000L == 0L) {
                    System.out.println("Pass 1: Processing Synset # " + lineNum + "...");
                }
                ++lineNum;
            }
            System.out.println("Finished first pass, starting second pass...");
            Long[] keys = offsetMap.keySet().toArray(new Long[offsetMap.size()]);
            offsetMap = null;
            Comparator c = new Comparator(){

                public int compare(Object o1, Object o2) {
                    long l1 = (Long)o1;
                    long l2 = (Long)o2;
                    return (int)(l1 - l2);
                }

                public boolean equals(Object obj) {
                    return true;
                }
            };
            Arrays.sort(keys, c);
            HashMap<Long, List> newEntailedByMap = new HashMap<Long, List>();
            HashMap<Long, Long> newOffsetMap = new HashMap<Long, Long>();
            long oldOffset = 0L;
            long newOffset = 0L;
            long add = 0L;
            for (int i = 0; i < keys.length; ++i) {
                Long key = keys[i];
                List list = (List)entailedByMap.get(key);
                oldOffset = key;
                newOffset = oldOffset + add;
                if (list != null) {
                    add += (long)(list.size() * 18);
                }
                newOffsetMap.put(new Long(oldOffset), new Long(newOffset));
                if (list == null) continue;
                newEntailedByMap.put(new Long(newOffset), list);
            }
            entailedByMap = null;
            System.out.println("Finished second pass, starting third pass...");
            HashMap finalEntailedByMap = new HashMap();
            Iterator itr2 = newEntailedByMap.keySet().iterator();
            while (itr2.hasNext()) {
                Long key = (Long)itr2.next();
                List list = (List)newEntailedByMap.get(key);
                ArrayList<Long> newOffsets = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    newOffsets.add(this.get((Long)list.get(i), (Map)newOffsetMap));
                }
                finalEntailedByMap.put(key, newOffsets);
            }
            System.out.println("Finished third pass, creating new data file...");
            RandomAccessFile newVerbIdx = new RandomAccessFile(this.verbIdxName, "rw");
            RandomAccessFile newVerbDat = new RandomAccessFile(this.verbDatName, "rw");
            DictionaryCatalogSet cat = new DictionaryCatalogSet(this.path, class$net$didion$jwnl$princeton$file$PrincetonRandomAccessDictionaryFile == null ? (class$net$didion$jwnl$princeton$file$PrincetonRandomAccessDictionaryFile = AddReverseEntailment.class$("net.didion.jwnl.princeton.file.PrincetonRandomAccessDictionaryFile")) : class$net$didion$jwnl$princeton$file$PrincetonRandomAccessDictionaryFile);
            cat.open();
            RandomAccessDictionaryFile verbDat = (RandomAccessDictionaryFile)cat.getDictionaryFile(POS.VERB, DictionaryFileType.DATA);
            try {
                verbDat.seek(0L);
                String line = verbDat.readLine();
                lineNum = 0L;
                long offset = 0L;
                while (line.startsWith("  ")) {
                    newVerbDat.writeBytes(line + "\n");
                    offset += (long)(line.length() + 1);
                    line = verbDat.readLine();
                    ++lineNum;
                }
                while (line != null) {
                    Synset synset = this.getDictionaryElementFactory().createSynset(POS.VERB, line);
                    Pointer[] pointers = synset.getPointers();
                    int pointerCount = pointers.length;
                    line = this.replace(line, pointers, newOffsetMap);
                    int insertIndex = line.indexOf("+") - 4;
                    Long insertOffset = this.get(offset, (Map)newOffsetMap);
                    String insertOffsetString = this.pad(insertOffset.toString());
                    StringBuffer newLine = new StringBuffer();
                    List pointerOffsetList = (List)finalEntailedByMap.get(insertOffset);
                    if (pointerOffsetList != null) {
                        int ptrCountIndex = line.indexOf(" " + this.pad(String.valueOf(pointerCount), 3)) + 1;
                        newLine.append(insertOffsetString);
                        newLine.append(line.substring(8, ptrCountIndex));
                        newLine.append(this.pad(String.valueOf(pointerCount + pointerOffsetList.size()), 3));
                        newLine.append(line.substring(ptrCountIndex + 3, insertIndex));
                        for (int i = 0; i < pointerOffsetList.size(); ++i) {
                            insertOffsetString = this.pad(pointerOffsetList.get(i).toString());
                            newLine.append(" ");
                            newLine.append(JWNL.resolveMessage((String)"ENTAILED_BY_KEY"));
                            newLine.append(" ");
                            newLine.append(insertOffsetString);
                            newLine.append(" ");
                            newLine.append(JWNL.resolveMessage((String)"VERB_KEY"));
                            newLine.append(" 0000");
                        }
                        newLine.append(line.substring(insertIndex, line.length()));
                    } else {
                        newLine.append(insertOffsetString);
                        newLine.append(line.substring(8));
                    }
                    newLine.append("\n");
                    newVerbDat.writeBytes(newLine.toString());
                    offset += (long)(line.length() + 1);
                    line = verbDat.readLine();
                    if (++lineNum % 1000L != 0L) continue;
                    System.out.println("Creating data file: wrote line " + lineNum + "...");
                }
            }
            catch (EOFException ex) {
                verbDat.close();
                newVerbDat.close();
            }
            System.out.println("Finished writing data file, writing new index file...");
            RandomAccessDictionaryFile verbIdx = (RandomAccessDictionaryFile)cat.getDictionaryFile(POS.VERB, DictionaryFileType.INDEX);
            try {
                String line = verbIdx.readLine();
                lineNum = 0L;
                while (line.startsWith("  ")) {
                    newVerbIdx.writeBytes(line + "\n");
                    line = verbIdx.readLine();
                    ++lineNum;
                }
                while (line != null) {
                    IndexWord word = this.getDictionaryElementFactory().createIndexWord(POS.VERB, line);
                    long[] offsets = word.getSynsetOffsets();
                    line = this.changePointerInfo(line, offsets, newOffsetMap, finalEntailedByMap);
                    line = this.replace(line, offsets, newOffsetMap);
                    newVerbIdx.writeBytes(line + "\n");
                    line = verbIdx.readLine();
                    if (++lineNum % 1000L != 0L) continue;
                    System.out.println("Creating index file: wrote line " + lineNum + "...");
                }
            }
            catch (EOFException ex) {
                verbIdx.close();
                newVerbIdx.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private FileDictionaryElementFactory getDictionaryElementFactory() {
        if (Dictionary.getInstance() instanceof FileBackedDictionary) {
            return ((FileBackedDictionary)Dictionary.getInstance()).getDictionaryElementFactory();
        }
        throw new RuntimeException("Dictionary must be an instance of FileBackedDictionary");
    }

    private Long get(Long offset, Map offsetMap) {
        return (Long)offsetMap.get(offset);
    }

    private Long get(long offset, Map offsetMap) {
        return this.get(new Long(offset), offsetMap);
    }

    private String changePointerInfo(String line, long[] offsets, Map offsetMap, Map entailedByMap) {
        for (int i = 0; i < offsets.length; ++i) {
            if (entailedByMap.get(this.get(offsets[i], offsetMap)) == null) continue;
            StringBuffer newLine = new StringBuffer();
            int ptrCountIndex = line.indexOf("+") - 2;
            newLine.append(line.substring(0, ptrCountIndex));
            int newPtrCount = Integer.valueOf("" + line.charAt(ptrCountIndex)) + 1;
            newLine.append(newPtrCount);
            newLine.append(" ");
            newLine.append(JWNL.resolveMessage((String)"ENTAILED_BY_KEY"));
            newLine.append(line.substring(ptrCountIndex + 1, line.length()));
            return newLine.toString();
        }
        return line;
    }

    private String replace(String line, Pointer[] pointers, Map offsetMap) {
        long[] offsets = new long[pointers.length];
        for (int i = 0; i < pointers.length; ++i) {
            offsets[i] = pointers[i].getTargetOffset();
        }
        return this.replace(line, offsets, offsetMap);
    }

    private String replace(String line, long[] offsets, Map offsetMap) {
        StringBuffer newLine = new StringBuffer();
        int startIndex = 0;
        for (int i = 0; i < offsets.length; ++i) {
            int insertIndex = line.indexOf(this.pad(String.valueOf(offsets[i])), startIndex);
            newLine.append(line.substring(startIndex, insertIndex));
            newLine.append(this.pad(this.get(offsets[i], offsetMap).toString()));
            startIndex = insertIndex + 8;
        }
        newLine.append(line.substring(startIndex, line.length()));
        return newLine.toString();
    }

    private String pad(String s) {
        return this.pad(s, 8);
    }

    private String pad(String s, int totalSize) {
        int numChars = totalSize - s.length();
        String newStr = "";
        if (numChars > 0) {
            char[] pad = new char[numChars];
            Arrays.fill(pad, '0');
            newStr = new String(pad);
        }
        return newStr + s;
    }

    private void add(long key, long val, Map h) {
        Long k = new Long(key);
        Long v = new Long(val);
        ArrayList<Long> vals = (ArrayList<Long>)h.get(k);
        if (vals == null) {
            vals = new ArrayList<Long>();
            vals.add(v);
            h.put(k, vals);
        } else {
            vals.add(v);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

