/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.Exc;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.Verb;
import net.didion.jwnl.data.Word;
import net.didion.jwnl.dictionary.AbstractCachingDictionary;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.database.ConnectionManager;
import net.didion.jwnl.util.MessageLog;
import net.didion.jwnl.util.MessageLogLevel;

public class DictionaryToDatabase {
    private static final MessageLog _log = new MessageLog(class$net$didion$jwnl$utilities$DictionaryToDatabase == null ? (class$net$didion$jwnl$utilities$DictionaryToDatabase = DictionaryToDatabase.class$("net.didion.jwnl.utilities.DictionaryToDatabase")) : class$net$didion$jwnl$utilities$DictionaryToDatabase);
    private static final String USAGE = "java net.didion.jwnl.utilities.DictionaryToDatabase <property file> <create tables script> <driver class> <connection url> [username [password]]";
    private static final String INSERT_INDEX_WORD = "INSERT INTO IndexWord VALUES(?,?,?)";
    private static final String INSERT_SYNSET = "INSERT INTO Synset VALUES(?,?,?,?,?)";
    private static final String INSERT_SYNSET_WORD = "INSERT INTO SynsetWord VALUES(?,?,?,?)";
    private static final String INSERT_SYNSET_POINTER = "INSERT INTO SynsetPointer VALUES(?,?,?,?,?,?,?)";
    private static final String INSERT_SYNSET_VERB_FRAME = "INSERT INTO SynsetVerbFrame VALUES(?,?,?,?)";
    private static final String INSERT_INDEX_WORD_SYNSET = "INSERT INTO IndexWordSynset VALUES(?,?,?)";
    private static final String INSERT_EXCEPTION = "INSERT INTO Exception VALUES(?,?,?,?)";
    private static int _id = 0;
    private static long _time = 0L;
    private Connection _conn;
    private Map _iwIdToSynsetOffset = new HashMap();
    private Map _synsetOffsetToId = new HashMap();
    static /* synthetic */ Class class$net$didion$jwnl$utilities$DictionaryToDatabase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println(USAGE);
            System.exit(-1);
        }
        try {
            JWNL.initialize((InputStream)new FileInputStream(args[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        Connection conn = null;
        String createTablesScript = args[1];
        ConnectionManager mgr = new ConnectionManager(args[2], args[3], args.length > 4 ? args[4] : null, args.length > 5 ? args[5] : null);
        conn = mgr.getConnection();
        DictionaryToDatabase d2d = new DictionaryToDatabase(conn);
        d2d.createTables(createTablesScript);
        d2d.insertData();
        Object var6_7 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException ex) {}
        return;
        {
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
                Object var6_8 = null;
                if (conn == null) return;
                try {
                    conn.close();
                    return;
                }
                catch (SQLException ex) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static synchronized int nextId() {
        if (_log.isLevelEnabled(MessageLogLevel.DEBUG) && ++_id % 1000 == 0) {
            long temp = System.currentTimeMillis();
            _log.log(MessageLogLevel.DEBUG, "inserted " + _id + "th entry");
            _log.log(MessageLogLevel.DEBUG, "free memory: " + Runtime.getRuntime().freeMemory());
            _log.log(MessageLogLevel.DEBUG, "time: " + (temp - _time));
            _time = System.currentTimeMillis();
        }
        return _id;
    }

    public DictionaryToDatabase(Connection conn) {
        this._conn = conn;
        ((AbstractCachingDictionary)Dictionary.getInstance()).setCachingEnabled(false);
    }

    public void createTables(String script) throws IOException, SQLException {
        _log.log(MessageLogLevel.INFO, "creating tables");
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(script)));
        StringBuffer buf = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                buf.append(line);
                if (line.endsWith(";")) {
                    System.out.println(buf.toString());
                    this._conn.prepareStatement(buf.toString()).execute();
                    buf = new StringBuffer();
                } else {
                    buf.append(" ");
                }
            }
            line = reader.readLine();
        }
        _log.log(MessageLogLevel.INFO, "creating tables");
    }

    public void insertData() throws Exception {
        _time = System.currentTimeMillis();
        Iterator posItr = POS.getAllPOS().iterator();
        while (posItr.hasNext()) {
            POS pos = (POS)posItr.next();
            _log.log(MessageLogLevel.INFO, "inserting data for pos " + pos);
            this.storeIndexWords(Dictionary.getInstance().getIndexWordIterator(pos));
            this.storeSynsets(Dictionary.getInstance().getSynsetIterator(pos));
            this.storeIndexWordSynsets();
            this.storeExceptions(Dictionary.getInstance().getExceptionIterator(pos));
            this._iwIdToSynsetOffset.clear();
            this._synsetOffsetToId.clear();
            _log.log(MessageLogLevel.INFO, "done inserting data for pos " + pos);
        }
    }

    private void storeIndexWords(Iterator itr) throws SQLException {
        _log.log(MessageLogLevel.INFO, "storing index words");
        PreparedStatement iwStmt = this._conn.prepareStatement(INSERT_INDEX_WORD);
        int count = 0;
        while (itr.hasNext()) {
            IndexWord iw = (IndexWord)itr.next();
            int id = DictionaryToDatabase.nextId();
            iwStmt.setInt(1, id);
            iwStmt.setString(2, iw.getLemma());
            iwStmt.setString(3, iw.getPOS().getKey());
            iwStmt.execute();
            this._iwIdToSynsetOffset.put(new Integer(id), iw.getSynsetOffsets());
            if (count++ % 100 != 0) continue;
            System.out.println(count);
        }
    }

    private void storeSynsets(Iterator itr) throws SQLException {
        PreparedStatement synsetStmt = this._conn.prepareStatement(INSERT_SYNSET);
        PreparedStatement synsetWordStmt = this._conn.prepareStatement(INSERT_SYNSET_WORD);
        PreparedStatement synsetPointerStmt = this._conn.prepareStatement(INSERT_SYNSET_POINTER);
        PreparedStatement synsetVerbFrameStmt = this._conn.prepareStatement(INSERT_SYNSET_VERB_FRAME);
        _log.log(MessageLogLevel.INFO, "storing synsets");
        while (itr.hasNext()) {
            Synset synset = (Synset)itr.next();
            int id = DictionaryToDatabase.nextId();
            this._synsetOffsetToId.put(new Long(synset.getOffset()), new Integer(id));
            synsetStmt.setInt(1, id);
            synsetStmt.setLong(2, synset.getOffset());
            synsetStmt.setString(3, synset.getPOS().getKey());
            synsetStmt.setBoolean(4, synset.isAdjectiveCluster());
            synsetStmt.setString(5, synset.getGloss());
            synsetStmt.execute();
            Word[] words = synset.getWords();
            synsetWordStmt.setInt(2, id);
            synsetVerbFrameStmt.setInt(2, id);
            for (int i = 0; i < words.length; ++i) {
                synsetWordStmt.setInt(1, DictionaryToDatabase.nextId());
                synsetWordStmt.setString(3, words[i].getLemma());
                synsetWordStmt.setInt(4, words[i].getIndex());
                synsetWordStmt.execute();
                if (!(words[i] instanceof Verb)) continue;
                synsetVerbFrameStmt.setInt(4, words[i].getIndex());
                int[] flags = ((Verb)words[i]).getVerbFrameIndicies();
                for (int j = 0; j < flags.length; ++j) {
                    synsetVerbFrameStmt.setInt(1, DictionaryToDatabase.nextId());
                    synsetVerbFrameStmt.setInt(3, flags[j]);
                    synsetVerbFrameStmt.execute();
                }
            }
            Pointer[] pointers = synset.getPointers();
            synsetPointerStmt.setInt(2, id);
            for (int i = 0; i < pointers.length; ++i) {
                synsetPointerStmt.setInt(1, DictionaryToDatabase.nextId());
                synsetPointerStmt.setString(3, pointers[i].getType().getKey());
                synsetPointerStmt.setLong(4, pointers[i].getTargetOffset());
                synsetPointerStmt.setString(5, pointers[i].getTargetPOS().getKey());
                synsetPointerStmt.setInt(6, pointers[i].getSourceIndex());
                synsetPointerStmt.setInt(7, pointers[i].getTargetIndex());
                synsetPointerStmt.execute();
            }
        }
    }

    private void storeIndexWordSynsets() throws SQLException {
        _log.log(MessageLogLevel.INFO, "storing index word synsets");
        PreparedStatement iwsStmt = this._conn.prepareStatement(INSERT_INDEX_WORD_SYNSET);
        Iterator itr = this._iwIdToSynsetOffset.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            int iwId = (Integer)entry.getKey();
            iwsStmt.setInt(2, iwId);
            long[] offsets = (long[])entry.getValue();
            for (int i = 0; i < offsets.length; ++i) {
                Integer offset = (Integer)this._synsetOffsetToId.get(new Long(offsets[i]));
                int synsetId = offset;
                iwsStmt.setInt(1, DictionaryToDatabase.nextId());
                iwsStmt.setLong(3, synsetId);
                iwsStmt.execute();
            }
        }
    }

    private void storeExceptions(Iterator itr) throws SQLException {
        _log.log(MessageLogLevel.INFO, "storing exceptions");
        PreparedStatement exStmt = this._conn.prepareStatement(INSERT_EXCEPTION);
        while (itr.hasNext()) {
            Exc exc = (Exc)itr.next();
            exStmt.setString(4, exc.getLemma());
            Iterator excItr = exc.getExceptions().iterator();
            while (excItr.hasNext()) {
                exStmt.setInt(1, DictionaryToDatabase.nextId());
                exStmt.setString(2, exc.getPOS().getKey());
                exStmt.setString(3, (String)excItr.next());
                exStmt.execute();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

