/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.dictionary.Dictionary;

public final class PerformanceTester {
    private static final DateFormat FORMAT = new SimpleDateFormat("hh:mm:ss");

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Syntax: java PerformanceTester <properties file> <test filename>");
            System.exit(-1);
        }
        try {
            JWNL.initialize((InputStream)new FileInputStream(args[0]));
            new PerformanceTester(args[1]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public PerformanceTester(String testfile) throws JWNLException {
        int counter = 0;
        String line = null;
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(testfile)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                line = lnr.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (line == null) break;
            long t1 = System.currentTimeMillis();
            System.out.println("Testing \"" + line + "\"...");
            IndexWordSet set = Dictionary.getInstance().lookupAllIndexWords(line);
            long t2 = System.currentTimeMillis();
            System.out.println(set.toString());
            System.out.println("Number " + counter++ + ": Time: " + (t2 - t1) + " milliseconds" + ", Word (Number of POS's): " + set.getLemma() + " (" + set.size() + ")");
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        Date total = new Date(totalTime);
        System.out.println("Total Time: " + FORMAT.format(total));
        Date average = new Date(totalTime / (long)counter);
        System.out.println("Average Time: " + FORMAT.format(average));
    }
}

