/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class TextInterface {
    public static void main(String[] args) {
        try {
            JWNL.initialize((InputStream)new FileInputStream(args[0]));
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            List posList = POS.getAllPOS();
            block2: while (true) {
                System.out.print("> ");
                String word = reader.readLine().trim();
                System.out.println();
                Iterator itr = posList.iterator();
                while (true) {
                    if (!itr.hasNext()) continue block2;
                    POS pos = (POS)itr.next();
                    IndexWord iw = Dictionary.getInstance().lookupIndexWord(pos, word);
                    if (iw == null) continue;
                    System.out.println(pos.getLabel());
                    for (int i = 1; i <= iw.getSenseCount(); ++i) {
                        Synset s = iw.getSense(i);
                        System.out.println(i + ") " + s.getGloss());
                    }
                    System.out.println();
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
            return;
        }
    }
}

