/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.utilities;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;
import net.didion.jwnl.dictionary.FileBackedDictionary;

public class VocabTrainer {
    private static final int NUM_CHOICES = 4;
    private static final Random _rand = new Random(new Date().getTime());

    public static void main(String[] args) {
        try {
            JWNL.initialize((InputStream)new FileInputStream(args[0]));
            VocabTrainer.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public static void run() throws Exception {
        FileBackedDictionary dictionary = (FileBackedDictionary)Dictionary.getInstance();
        List allPOS = POS.getAllPOS();
        while (true) {
            int i;
            int correctChoice;
            POS pos;
            IndexWord[] choices;
            if ((choices = VocabTrainer.getChoices(dictionary, 4, pos = (POS)allPOS.get(_rand.nextInt(allPOS.size()))))[correctChoice = _rand.nextInt(4)].getLemma().indexOf(" ") >= 0) {
                continue;
            }
            Pointer[][] pointers = new Pointer[choices[correctChoice].getSenseCount()][];
            int sense = -1;
            int maxPointers = 0;
            for (i = 0; i < pointers.length; ++i) {
                pointers[i] = VocabTrainer.getPointers(choices[correctChoice].getSense(i + 1), pos);
                if (pointers[i] == null || pointers[i].length <= maxPointers) continue;
                sense = i;
                maxPointers = pointers[i].length;
            }
            if (sense < 0) continue;
            System.out.println();
            System.out.println("> " + choices[correctChoice].getLemma());
            for (i = 0; i < choices.length; ++i) {
                System.out.print(i + 1 + ") ");
                if (i == correctChoice) {
                    String lemma = null;
                    for (int j = 0; j < pointers[sense].length && (lemma == null || lemma.equals(choices[correctChoice].getLemma())); ++j) {
                        Synset s = pointers[sense][j].getTargetSynset();
                        for (int k = 0; k < s.getWordsSize() && (lemma == null || lemma.equals(choices[correctChoice].getLemma())); ++k) {
                            lemma = s.getWord(k).getLemma();
                        }
                    }
                    System.out.println(lemma);
                    continue;
                }
                System.out.println(choices[i].getLemma());
            }
            int choice = 0;
            while (choice < 1 || choice > 4) {
                System.out.print("? ");
                try {
                    StringBuffer buf = new StringBuffer();
                    int c = -1;
                    while ((c = System.in.read()) != 10) {
                        buf.append((char)c);
                    }
                    choice = Integer.parseInt(buf.toString());
                }
                catch (Exception ex) {}
            }
            if (choice == correctChoice + 1) {
                System.out.println("correct!");
            } else {
                System.out.println("wrong! the correct answer is: " + (correctChoice + 1));
            }
            System.out.println(choices[correctChoice].getLemma() + ": " + choices[correctChoice].getSense(sense + 1).getGloss());
        }
    }

    private static Pointer[] getPointers(Synset synset, POS pos) {
        if (pos == POS.NOUN) {
            return synset.getPointers(PointerType.SEE_ALSO);
        }
        if (pos == POS.VERB) {
            return synset.getPointers(PointerType.VERB_GROUP);
        }
        if (pos == POS.ADJECTIVE) {
            ArrayList<Pointer> pointers = new ArrayList<Pointer>();
            pointers.addAll(Arrays.asList(synset.getPointers(PointerType.SIMILAR_TO)));
            pointers.addAll(Arrays.asList(synset.getPointers(PointerType.SEE_ALSO)));
            return pointers.toArray(new Pointer[pointers.size()]);
        }
        if (pos == POS.ADVERB) {
            return synset.getPointers(PointerType.DERIVED);
        }
        return null;
    }

    private static IndexWord[] getChoices(FileBackedDictionary dict, int numChoices, POS pos) throws Exception {
        IndexWord[] choices = new IndexWord[numChoices];
        for (int i = 0; i < numChoices; ++i) {
            choices[i] = dict.getRandomIndexWord(pos);
        }
        return choices;
    }
}

