/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;
import uk.ac.man.cs.img.owl.validation.ValidationTest;
import uk.ac.man.cs.img.owl.validation.ValidatorLogger;

public class ExpressivityTest
extends ValidationTest {
    public ExpressivityTest(String testName, OWLDataFactory factory) {
        super(testName, factory);
    }

    public static Test suite(OWLDataFactory fact) {
        TestSuite suite = new TestSuite("Expressivity");
        suite.addTest((Test)new ExpressivityTest("testEnumeration", fact));
        suite.addTest((Test)new ExpressivityTest("testNegation", fact));
        suite.addTest((Test)new ExpressivityTest("testOr", fact));
        suite.addTest((Test)new ExpressivityTest("testObjectValueRestriction", fact));
        return suite;
    }

    public void testEnumeration() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-enum");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ExpressivityTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        AddEnumeration evt = new AddEnumeration(ontology, this.testClasses[0], this.testEnum, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ExpressivityTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }

    public void testNegation() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-neg");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ExpressivityTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        AddSuperClass evt = new AddSuperClass(ontology, this.testClasses[0], (OWLDescription)this.testNot, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ExpressivityTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }

    public void testOr() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-or");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ExpressivityTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        AddSuperClass evt = new AddSuperClass(ontology, this.testClasses[0], (OWLDescription)this.testOr, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ExpressivityTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }

    public void testObjectValueRestriction() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-ovr");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ExpressivityTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        AddSuperClass evt = new AddSuperClass(ontology, this.testClasses[0], (OWLDescription)this.testObjectValueRestriction, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ExpressivityTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }
}

