/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;
import uk.ac.man.cs.img.owl.validation.TestUtils;
import uk.ac.man.cs.img.owl.validation.ValidatorLogger;

public class NamespaceSeparationTest
extends TestCase {
    private OWLDataFactory factory;
    private OWLEntity[] entities;
    private SpeciesValidator sv;

    public NamespaceSeparationTest(String testName, OWLDataFactory factory) {
        super(testName);
        this.factory = factory;
    }

    public static Test suite(OWLDataFactory fact) {
        TestSuite suite = new TestSuite("NamespaceSeparation");
        suite.addTest((Test)new NamespaceSeparationTest("testSeparationLite1", fact));
        suite.addTest((Test)new NamespaceSeparationTest("testSeparationLite2", fact));
        suite.addTest((Test)new NamespaceSeparationTest("testSeparationFull", fact));
        return suite;
    }

    public void testSeparationLite1() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-onto-sep-lite-1");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        uri = new URI("http://example.org/test-onto#Class1");
        TestUtils.addClass(ontology, this.factory, (ChangeVisitor)changeVisitor, uri);
        NamespaceSeparationTest.assertTrue((boolean)sv.isOWLLite(ontology));
    }

    public void testSeparationLite2() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-onto-sep-lite-2");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        uri = new URI("http://example.org/test-onto#name1");
        OWLClass clazz = TestUtils.addClass(ontology, this.factory, (ChangeVisitor)changeVisitor, uri);
        uri = new URI("http://example.org/test-onto#name2");
        OWLIndividual ind = TestUtils.addIndividual(ontology, this.factory, (ChangeVisitor)changeVisitor, uri);
        AddIndividualClass aic = new AddIndividualClass(ontology, ind, (OWLDescription)this.factory.getOWLThing(), null);
        aic.accept((ChangeVisitor)changeVisitor);
        NamespaceSeparationTest.assertTrue((boolean)sv.isOWLLite(ontology));
    }

    public void setUp() {
        try {
            this.sv = new SpeciesValidator();
            this.sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
            URI uri = null;
            try {
                uri = new URI("http://example.org/test#name");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            this.entities = new OWLEntity[4];
            this.entities[0] = this.factory.getOWLClass(uri);
            this.entities[1] = this.factory.getOWLIndividual(uri);
            this.entities[2] = this.factory.getOWLObjectProperty(uri);
            this.entities[3] = this.factory.getOWLDataProperty(uri);
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
    }

    private void testSeparation(int j, int[] indices) throws Throwable {
        URI uri = new URI("http://example.org/test-onto" + j);
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        for (int i = 0; i < indices.length; ++i) {
            AddEntity evt = new AddEntity(ontology, this.entities[i], null);
            evt.accept((ChangeVisitor)changeVisitor);
        }
        NamespaceSeparationTest.assertTrue((!this.sv.isOWLLite(ontology) ? 1 : 0) != 0);
        NamespaceSeparationTest.assertTrue((!this.sv.isOWLDL(ontology) ? 1 : 0) != 0);
        NamespaceSeparationTest.assertTrue((boolean)this.sv.isOWLFull(ontology));
    }

    public void testSeparationFull() throws Throwable {
        this.setUp();
        int[][] entityIndices = new int[][]{{0, 1}, {0, 2}, {0, 3}, {1, 2}, {1, 3}, {2, 3}, {0, 1, 2}, {0, 2, 3}, {1, 2, 3}, {0, 1, 2, 3}};
        for (int i = 0; i < entityIndices.length; ++i) {
            this.testSeparation(i, entityIndices[i]);
        }
    }
}

