/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class OWLTestForWG {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$OWLTestForWG == null ? (class$uk$ac$man$cs$img$owl$validation$OWLTestForWG = OWLTestForWG.class$("uk.ac.man.cs.img.owl.validation.OWLTestForWG")) : class$uk$ac$man$cs$img$owl$validation$OWLTestForWG));
    private SpeciesValidator sv;
    private String manifestURI;
    private String resultsURL;
    private OWLTest test;
    private OWLConnection connection;
    private PrintWriter rdfResults;
    private PrintWriter textResults;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$OWLTestForWG;

    public OWLTestForWG(OWLConnection connection, OWLTest test, Writer r, Writer t, String ru) {
        this.connection = connection;
        this.test = test;
        this.rdfResults = new PrintWriter(r);
        this.textResults = new PrintWriter(t);
        this.resultsURL = ru;
    }

    public void runTest() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        SpeciesValidatorReporter rep = new SpeciesValidatorReporter(){

            public void message(String str) {
                OWLTestForWG.this.textResults.println("  " + str);
            }

            public void explain(int l, String str) {
                OWLTestForWG.this.textResults.println("  " + SpeciesValidator.level((int)l) + ":\t" + str);
            }

            public void explain(int l, int code, String str) {
                OWLTestForWG.this.textResults.println("  " + SpeciesValidator.level((int)l) + "[" + code + "]:\t" + str);
            }

            public void ontology(OWLOntology ontology) {
            }

            public void done(String level) {
            }
        };
        sv.setReporter(rep);
        boolean pass = true;
        String anchor = URLEncoder.encode(this.test.getURI());
        this.textResults.println("<a name=\"" + anchor + "\"></a>");
        Iterator it = this.test.getDocuments().iterator();
        while (it.hasNext()) {
            boolean ok;
            String doc = (String)it.next();
            Set levels = (Set)this.test.getDocumentLevels().get(doc);
            URI ontoURI = new URI(doc + "");
            this.textResults.println("++++ Checking " + this.test.getURI() + " ++++");
            if (levels == null) continue;
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                this.textResults.println(" == " + doc + " Lite...");
                ok = true;
                this.textResults.println(" Lite...");
                boolean bl = ok = ok && sv.isOWLLite(ontoURI);
                if (ok) {
                    this.textResults.println(" " + doc + " OK");
                    continue;
                }
                this.textResults.println(" " + doc + " BAD");
                pass = false;
                continue;
            }
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                this.textResults.println(" == " + doc + " DL...");
                ok = true;
                this.textResults.println(" Not Lite...");
                ok = ok && !sv.isOWLLite(ontoURI);
                this.textResults.println(" DL...");
                boolean bl = ok = ok && sv.isOWLDL(ontoURI);
                if (ok) {
                    this.textResults.println(" " + doc + " OK");
                    continue;
                }
                this.textResults.println(" " + doc + " BAD");
                pass = false;
                continue;
            }
            if (!levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) continue;
            this.textResults.println(" == " + doc + " Full...");
            ok = true;
            this.textResults.println(" Not Lite...");
            ok = ok && !sv.isOWLLite(ontoURI);
            this.textResults.println(" Not DL...");
            ok = ok && !sv.isOWLDL(ontoURI);
            this.textResults.println(" Full...");
            boolean bl = ok = ok && sv.isOWLFull(ontoURI);
            if (ok) {
                this.textResults.println(" " + doc + " OK");
                continue;
            }
            this.textResults.println(" " + doc + " BAD");
            pass = false;
        }
        if (pass) {
            this.pass(this.test.getURI());
        } else {
            this.fail(this.test.getURI());
        }
    }

    private void pass(String uri) {
        this.rdfResults.println("<results:TestRun>");
        this.rdfResults.println(" <results:system rdf:resource=\"#wonderweb\"/>");
        this.rdfResults.println(" <results:output rdf:resource=\"" + this.resultsURL + "#" + URLEncoder.encode(uri) + "\"/>");
        this.rdfResults.println(" <rdf:type rdf:resource=\"http://www.w3.org/2002/03owlt/resultsOntology#PassingRun\"/>");
        this.rdfResults.println(" <results:test rdf:parseType=\"Resource\">");
        this.rdfResults.println("  <results:syntacticLevelTestFrom rdf:resource=\"" + uri + "\"/>");
        this.rdfResults.println(" </results:test>");
        this.rdfResults.println("</results:TestRun>");
    }

    private void fail(String uri) {
        this.rdfResults.println("<results:TestRun>");
        this.rdfResults.println(" <results:system rdf:resource=\"#wonderweb\"/>");
        this.rdfResults.println(" <results:output rdf:resource=\"" + this.resultsURL + "#" + URLEncoder.encode(uri) + "\"/>");
        this.rdfResults.println(" <rdf:type rdf:resource=\"http://www.w3.org/2002/03owlt/resultsOntology#FailingRun\"/>");
        this.rdfResults.println(" <results:test rdf:parseType=\"Resource\">");
        this.rdfResults.println("  <results:syntacticLevelTestFrom rdf:resource=\"" + uri + "\"/>");
        this.rdfResults.println(" </results:test>");
        this.rdfResults.println("</results:TestRun>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

