/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class OWLTestRunner {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$OWLTestRunner == null ? (class$uk$ac$man$cs$img$owl$validation$OWLTestRunner = OWLTestRunner.class$("uk.ac.man.cs.img.owl.validation.OWLTestRunner")) : class$uk$ac$man$cs$img$owl$validation$OWLTestRunner));
    private OWLConnection connection;
    private PrintWriter htmlResults;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$OWLTestRunner;

    public OWLTestRunner(OWLConnection connection) {
        this.connection = connection;
    }

    public OWLTestRunner() {
        try {
            this.connection = OWLManager.getOWLConnection();
        }
        catch (OWLException e) {
            this.connection = null;
        }
    }

    public void dropAllOntologies() throws OWLException {
        Set ontos = this.connection.getAllOntologies();
        Iterator ontoIt = ontos.iterator();
        while (ontoIt.hasNext()) {
            OWLOntology o = (OWLOntology)ontoIt.next();
            this.connection.notifyOntologyDeleted(o);
        }
    }

    public void runTest(URI testURL, Writer h) throws Throwable {
        this.htmlResults = new PrintWriter(h);
        OWLTestParser parser = new OWLTestParser();
        OWLTest test = parser.parseTest(testURL);
        SpeciesValidator sv = new SpeciesValidator();
        sv.setConnection(this.connection);
        SpeciesValidatorReporter rep = new SpeciesValidatorReporter(){

            public void message(String str) {
                OWLTestRunner.this.htmlResults.println("<li>" + str + "</li>");
            }

            public void explain(int l, String str) {
                OWLTestRunner.this.htmlResults.println("<li>" + SpeciesValidator.level((int)l) + ":\t" + str + "</li>");
            }

            public void explain(int l, int code, String str) {
                OWLTestRunner.this.htmlResults.println("<li>" + SpeciesValidator.level((int)l) + ":\t" + str + "</li>");
            }

            public void ontology(OWLOntology ontology) {
            }

            public void done(String level) {
            }
        };
        sv.setReporter(rep);
        boolean pass = true;
        this.htmlResults.println("<h2>Test: <a href='" + test.getURI() + "'>" + test.getURI() + "</a></h2>");
        Iterator it = test.getDocuments().iterator();
        while (it.hasNext()) {
            boolean ok;
            String doc = (String)it.next();
            Set levels = (Set)test.getDocumentLevels().get(doc);
            URI ontoURI = new URI(doc + "");
            this.htmlResults.println("<hr/>");
            if (levels == null) continue;
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                this.htmlResults.println("<h3>Ontology: <a href='" + doc + "'>" + doc + "</a> Lite</h3>");
                this.htmlResults.println("<p><pre>");
                ok = true;
                this.htmlResults.println("Checking Lite");
                this.htmlResults.println("</p><ul>");
                this.dropAllOntologies();
                ok = ok && sv.isOWLLite(ontoURI);
                this.htmlResults.println("</ul><p>");
                if (ok) {
                    this.htmlResults.println(doc + " OK</p>");
                } else {
                    this.htmlResults.println(doc + " BAD</p>");
                    pass = false;
                }
                this.htmlResults.println("</pre></p>");
                continue;
            }
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                this.htmlResults.println("<h3>Ontology: <a href='" + doc + "'>" + doc + "</a> DL</h3>");
                this.htmlResults.println("<p><pre>");
                ok = true;
                this.htmlResults.println("Checking Not Lite");
                this.htmlResults.println("</p><ul>");
                this.dropAllOntologies();
                ok = ok && !sv.isOWLLite(ontoURI);
                this.htmlResults.println("</ul><p>");
                this.htmlResults.println("Checking DL");
                this.htmlResults.println("</p><ul>");
                this.dropAllOntologies();
                ok = ok && sv.isOWLDL(ontoURI);
                this.htmlResults.println("</ul><p>");
                if (ok) {
                    this.htmlResults.println(doc + " OK</p>");
                } else {
                    this.htmlResults.println(doc + " BAD</p>");
                    pass = false;
                }
                this.htmlResults.println("</pre></p>");
                continue;
            }
            if (!levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) continue;
            this.htmlResults.println("<h3>Ontology: <a href='" + doc + "'>" + doc + "</a> Full</h3>");
            this.htmlResults.println("<p><pre>");
            ok = true;
            this.htmlResults.println("Checking Not Lite");
            this.htmlResults.println("</p><ul>");
            this.dropAllOntologies();
            ok = ok && !sv.isOWLLite(ontoURI);
            this.htmlResults.println("</ul><p>");
            this.htmlResults.println("Checking Not DL");
            this.htmlResults.println("</p><ul>");
            this.dropAllOntologies();
            ok = ok && !sv.isOWLDL(ontoURI);
            this.htmlResults.println("</ul><p>");
            this.htmlResults.println("Checking Full");
            this.htmlResults.println("</p><ul>");
            this.dropAllOntologies();
            ok = ok && sv.isOWLFull(ontoURI);
            this.htmlResults.println("</ul><p>");
            if (ok) {
                this.htmlResults.println(doc + " OK</p>");
            } else {
                this.htmlResults.println(doc + " BAD</p>");
                pass = false;
            }
            this.htmlResults.println("</pre></p>");
        }
        this.htmlResults.println("<hr/>");
        if (pass) {
            this.pass(test.getURI());
        } else {
            this.fail(test.getURI());
        }
    }

    private void pass(String uri) {
        this.htmlResults.println("<p><a href='" + uri + "'>" + uri + "</a>: <strong><span style='color:green'>Pass</span></strong></p>");
    }

    private void fail(String uri) {
        this.htmlResults.println("<p><a href='" + uri + "'>" + uri + "</a>: <strong><span style='color:red'>Fail</span></strong></p>");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            OutputStreamWriter htmlReport = new OutputStreamWriter(System.out);
            PrintWriter pw = new PrintWriter(htmlReport);
            pw.println("<html>");
            pw.println("<body>");
            OWLConnection connection = OWLManager.getOWLConnection();
            OWLDataFactory fact = connection.getDataFactory();
            OWLTestRunner otr = new OWLTestRunner(connection);
            otr.runTest(new URI(args[0]), htmlReport);
            pw.println("</body>");
            pw.println("</html>");
            ((Writer)htmlReport).close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

