/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestVocabularyAdapter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;
import uk.ac.man.cs.img.owl.validation.ValidatorLogger;

public class OWLTestTest
extends TestCase {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$validation$OWLTestTest == null ? (class$uk$ac$man$cs$img$owl$validation$OWLTestTest = OWLTestTest.class$("uk.ac.man.cs.img.owl.validation.OWLTestTest")) : class$uk$ac$man$cs$img$owl$validation$OWLTestTest));
    private SpeciesValidator sv;
    private String manifestURI;
    private OWLTest test;
    private OWLConnection connection;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$validation$OWLTestTest;

    public OWLTestTest(OWLConnection connection, OWLTest test) {
        super("OWLTest " + test.getURI());
        this.connection = connection;
        this.test = test;
    }

    public static Test suite(OWLConnection connection, Collection tests) {
        TestSuite suite = new TestSuite("OWLTest");
        try {
            Iterator it = tests.iterator();
            while (it.hasNext()) {
                OWLTest test = (OWLTest)it.next();
                suite.addTest((Test)new OWLTestTest(connection, test));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return suite;
    }

    public void runTest() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        sv.setConnection(this.connection);
        Iterator it = this.test.getDocuments().iterator();
        while (it.hasNext()) {
            String doc = (String)it.next();
            Set levels = (Set)this.test.getDocumentLevels().get(doc);
            URI ontoURI = new URI(doc + "");
            if (levels == null) continue;
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLLite())) {
                logger.info((Object)(doc + "" + " Lite..."));
                this.dropAllOntologies();
                OWLTestTest.assertTrue((String)(doc + "" + " Lite"), (boolean)sv.isOWLLite(ontoURI));
                logger.info((Object)(doc + "" + " OK!"));
                continue;
            }
            if (levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLDL())) {
                logger.info((Object)(doc + "" + " DL..."));
                this.dropAllOntologies();
                OWLTestTest.assertTrue((String)(doc + "" + " Not Lite"), (!sv.isOWLLite(ontoURI) ? 1 : 0) != 0);
                this.dropAllOntologies();
                OWLTestTest.assertTrue((String)(doc + "" + " DL"), (boolean)sv.isOWLDL(ontoURI));
                logger.info((Object)(doc + "" + " OK!"));
                continue;
            }
            if (!levels.contains(OWLTestVocabularyAdapter.INSTANCE.getOWLFull())) continue;
            logger.info((Object)(doc + "" + " Full..."));
            this.dropAllOntologies();
            OWLTestTest.assertTrue((String)(doc + "" + " Not Lite"), (!sv.isOWLLite(ontoURI) ? 1 : 0) != 0);
            this.dropAllOntologies();
            OWLTestTest.assertTrue((String)(doc + "" + " Not DL"), (!sv.isOWLDL(ontoURI) ? 1 : 0) != 0);
            this.dropAllOntologies();
            OWLTestTest.assertTrue((String)(doc + "" + " Full"), (boolean)sv.isOWLFull(ontoURI));
            logger.info((Object)(doc + "" + " OK!"));
        }
    }

    public void dropAllOntologies() throws OWLException {
        this.connection.dropAllOntologies();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

