/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;
import uk.ac.man.cs.img.owl.validation.ClassAxiomTest;
import uk.ac.man.cs.img.owl.validation.ExpressivityTest;
import uk.ac.man.cs.img.owl.validation.NamespaceSeparationTest;
import uk.ac.man.cs.img.owl.validation.OWLTestTest;
import uk.ac.man.cs.img.owl.validation.TransitiveSideConditionsTest;

public class SpeciesValidatorBuildTest
extends TestCase {
    public SpeciesValidatorBuildTest(String name) {
        super(name);
    }

    public static TestSuite suite() {
        BasicConfigurator.configure();
        TestSuite suite = new TestSuite("SpeciesValidatorBuild");
        try {
            OWLConnection connection = OWLManager.getOWLConnection();
            OWLDataFactory fact = connection.getDataFactory();
            suite.addTest(NamespaceSeparationTest.suite(fact));
            suite.addTest(ClassAxiomTest.suite(fact));
            suite.addTest(ExpressivityTest.suite(fact));
            suite.addTest(TransitiveSideConditionsTest.suite(fact));
            Object testManifests = null;
            ArrayList<OWLTest> tests = new ArrayList<OWLTest>();
            OWLTestParser parser = new OWLTestParser();
            URL testManifestsURL = ClassLoader.getSystemResource(System.getProperty("tests.manifests"));
            BufferedReader br = new BufferedReader(new InputStreamReader(testManifestsURL.openStream()));
            String f = null;
            while ((f = br.readLine()) != null) {
                if (f.startsWith("#")) continue;
                OWLTest test = parser.parseTest(new URI(f));
                tests.add(test);
            }
            suite.addTest(OWLTestTest.suite(connection, tests));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SpeciesValidatorBuildTest.suite());
    }
}

