/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.ChangeVisitor;

public class ValidationTest
extends TestCase {
    protected OWLDataFactory factory;
    protected OWLClass[] testClasses;
    protected OWLIndividual[] testIndividuals;
    protected OWLObjectProperty[] testObjectProperties;
    protected OWLDataProperty[] testDataProperties;
    protected OWLOr testOr;
    protected OWLAnd testAnd;
    protected OWLNot testNot;
    protected OWLEnumeration testEnum;
    protected OWLObjectValueRestriction testObjectValueRestriction;
    protected static int N = 5;

    public ValidationTest(String testName, OWLDataFactory factory) {
        super(testName);
        this.factory = factory;
    }

    public void setUp() {
        try {
            URI uri;
            int i;
            this.testClasses = new OWLClass[N];
            this.testIndividuals = new OWLIndividual[N];
            this.testObjectProperties = new OWLObjectProperty[N];
            this.testDataProperties = new OWLDataProperty[N];
            for (i = 0; i < N; ++i) {
                uri = new URI("http://example.org/test-onto#class" + i);
                this.testClasses[i] = this.factory.getOWLClass(uri);
            }
            for (i = 0; i < N; ++i) {
                uri = new URI("http://example.org/test-onto#individual" + i);
                this.testIndividuals[i] = this.factory.getOWLIndividual(uri);
            }
            for (i = 0; i < N; ++i) {
                uri = new URI("http://example.org/test-onto#oprop" + i);
                this.testObjectProperties[i] = this.factory.getOWLObjectProperty(uri);
            }
            for (i = 0; i < N; ++i) {
                uri = new URI("http://example.org/test-onto#dprop" + i);
                this.testDataProperties[i] = this.factory.getOWLDataProperty(uri);
            }
            HashSet<Object> set = new HashSet<Object>();
            set.add(this.testClasses[0]);
            set.add(this.testClasses[1]);
            this.testOr = this.factory.getOWLOr(set);
            set = new HashSet();
            set.add(this.testClasses[2]);
            set.add(this.testClasses[3]);
            this.testAnd = this.factory.getOWLAnd(set);
            this.testNot = this.factory.getOWLNot((OWLDescription)this.testClasses[4]);
            set = new HashSet();
            set.add(this.testIndividuals[0]);
            set.add(this.testIndividuals[1]);
            this.testEnum = this.factory.getOWLEnumeration(set);
            this.testObjectValueRestriction = this.factory.getOWLObjectValueRestriction(this.testObjectProperties[0], this.testIndividuals[0]);
        }
        catch (URISyntaxException ex) {
        }
        catch (OWLException oWLException) {
            // empty catch block
        }
    }

    public void addEntities(OWLOntology ontology, ChangeVisitor visitor) throws OWLException {
        for (int i = 0; i < N; ++i) {
            AddEntity evt = new AddEntity(ontology, (OWLEntity)this.testClasses[i], null);
            evt.accept(visitor);
            evt = new AddEntity(ontology, (OWLEntity)this.testIndividuals[i], null);
            AddIndividualClass aic = new AddIndividualClass(ontology, this.testIndividuals[i], (OWLDescription)this.factory.getOWLThing(), null);
            aic.accept(visitor);
            evt.accept(visitor);
        }
    }
}

