/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.io.rdfxml;

import com.clarkparsia.explanation.io.ExplanationRenderer;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.coode.owl.rdf.rdfxml.RDFXMLRenderer;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLOntology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLExplanationRenderer
implements ExplanationRenderer {
    private Set<OWLAxiom> axioms;
    private Writer writer;

    public void startRendering(Writer writer) {
        this.writer = writer;
        this.axioms = new HashSet<OWLAxiom>();
    }

    public void render(OWLAxiom axiom, Set<Set<OWLAxiom>> explanations) {
        this.axioms.add(axiom);
        for (Set<OWLAxiom> explanation : explanations) {
            this.axioms.addAll(explanation);
        }
    }

    public void endRendering() {
        OWLOntology ontology = OntologyUtils.getOntologyFromAxioms(this.axioms);
        RDFXMLRenderer renderer = new RDFXMLRenderer(OntologyUtils.getOWLOntologyManager(), ontology, this.writer);
        renderer.render();
    }
}

