/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import pellet.PelletCmdException;
import pellet.PelletCmdOptionArg;

public class PelletCmdOption {
    private String longOption;
    private String shortOption;
    private String type;
    private String description;
    private boolean isMandatory;
    private Object value;
    private Object defaultValue;
    private PelletCmdOptionArg arg = PelletCmdOptionArg.NONE;

    public PelletCmdOption(String longOption) {
        if (longOption == null) {
            throw new PelletCmdException("A long option must be defined for a command line option");
        }
        this.longOption = this.removeHyphen(longOption);
        this.defaultValue = null;
    }

    public String getShortOption() {
        return this.shortOption;
    }

    public String getLongOption() {
        return this.longOption;
    }

    public void setShortOption(String shortOption) {
        this.shortOption = this.removeHyphen(shortOption);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueAsString() {
        if (this.value != null) {
            return this.value.toString();
        }
        if (this.defaultValue != null) {
            return this.defaultValue.toString();
        }
        return null;
    }

    public Integer getValueAsInteger() {
        String value = this.getValueAsString();
        if (value != null) {
            try {
                Integer intValue = Integer.valueOf(value);
                if (intValue < 0) {
                    throw new PelletCmdException("The value for option <" + this.longOption + "> is not a positive integer: " + intValue);
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new PelletCmdException("The value for option <" + this.longOption + "> is not a valid integer: " + value);
            }
        }
        return null;
    }

    public Boolean getValueAsBoolean() {
        String value = this.getValueAsString();
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public void setIsMandatory(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PelletCmdOption)) {
            return false;
        }
        PelletCmdOption other = (PelletCmdOption)o;
        return (this.shortOption == null && other.getShortOption() == null || this.shortOption.equals(other.getShortOption())) && this.longOption.equals(other.getLongOption()) && (this.type == null && other.getType() == null || this.type.equals(other.getType())) && (this.description == null && other.getDescription() == null || this.description.equals(other.getDescription())) && this.isMandatory == other.isMandatory() && (this.value == null && other.getValue() == null || this.value.equals(other.getValue())) && (this.defaultValue == null && other.getDefaultValue() == null || this.defaultValue.equals(other.getDefaultValue()));
    }

    public String toString() {
        return "[ " + this.longOption + ", " + this.shortOption + ", " + this.type + ", " + this.description + ", " + this.isMandatory + ", " + this.value + ", " + this.defaultValue + " ]";
    }

    private String removeHyphen(String option) {
        int start = 0;
        while (option.charAt(start) == '-') {
            ++start;
        }
        return option.substring(start);
    }

    public void setArg(PelletCmdOptionArg arg) {
        this.arg = arg;
    }

    public PelletCmdOptionArg getArg() {
        return this.arg;
    }
}

