/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import pellet.PelletCmdApp;
import pellet.PelletCmdOptions;

public class PelletConsistency
extends PelletCmdApp {
    public PelletConsistency(String[] args) {
        super(args);
    }

    public String getAppCmd() {
        return "pellet consistency " + this.getMandatoryOptions() + "[options] <file URI>...";
    }

    public String getAppId() {
        return "PelletConsistency: Check the consistency of an ontology";
    }

    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        options.add(this.getLoaderOption());
        options.add(this.getInputFormatOption());
        return options;
    }

    public void run() {
        Timers timers = new Timers();
        KnowledgeBase kb = this.getKB();
        Timer t = timers.createTimer("Consistency");
        t.start();
        boolean isConsistent = kb.isConsistent();
        t.stop();
        this.out.print("Consistent: ");
        if (isConsistent) {
            this.out.println("Yes");
        } else {
            this.out.println("No");
            this.out.print("Reason: ");
            this.out.println(kb.getExplanation());
        }
    }

    public static void main(String[] args) {
        PelletConsistency app = new PelletConsistency(args);
        app.run();
    }
}

