/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.api.util;

import edu.unika.aifb.rdf.api.model.Model;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.util.RDFManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ModelContext {
    protected Map m_logicalToPhysicalURI = new HashMap();
    protected Map m_physicalURItoModel = new HashMap();
    protected Map m_logicalURItoModel = new HashMap();

    public synchronized void mapLogicalToPhysicalURI(String string, String string2) {
        this.m_logicalToPhysicalURI.put(string, string2);
    }

    public synchronized void unmapLogicalURI(String string) {
        this.m_logicalToPhysicalURI.remove(string);
    }

    public synchronized String getPhysicalFromLogicalURI(String string) {
        return (String)this.m_logicalToPhysicalURI.get(string);
    }

    public synchronized void registerModel(Model model) throws ModelException {
        this.registerModelInternal(model);
        Iterator iterator = model.getAllIncludedModels().iterator();
        while (iterator.hasNext()) {
            Model model2 = (Model)iterator.next();
            this.registerModelInternal(model2);
        }
    }

    protected void registerModelInternal(Model model) throws ModelException {
        this.m_physicalURItoModel.put(model.getPhysicalURI(), model);
        this.m_logicalURItoModel.put(model.getLogicalURI(), model);
    }

    public synchronized Model getModelPhysical(String string) throws ModelException {
        Model model = (Model)this.m_physicalURItoModel.get(string);
        if (model == null) {
            RDFManager.ModelInfo modelInfo = RDFManager.openModelEx(string, null);
            model = modelInfo.m_model;
            this.registerModelInternal(model);
            for (int i = 0; i < modelInfo.m_includedModels.length; ++i) {
                String string2;
                Model model2 = null;
                String string3 = modelInfo.m_includedModels[i][0];
                if (string3 != null && (model2 = (Model)this.m_logicalURItoModel.get(string3)) == null && (string2 = this.getPhysicalFromLogicalURI(string3)) != null) {
                    model2 = this.getModelPhysical(string2);
                }
                if (model2 == null) {
                    string2 = modelInfo.m_includedModels[i][1];
                    if (string2 == null) {
                        throw new ModelException("The logical to physical URI mapping for model '" + modelInfo.m_includedModels[i][0] + "'doesn't exist, so physical URI should be specified");
                    }
                    model2 = this.getModelPhysical(string2);
                }
                model.addIncludedModel(model2);
            }
        }
        return model;
    }

    public synchronized Model getModelLogical(String string) throws ModelException {
        Model model = (Model)this.m_logicalURItoModel.get(string);
        if (model == null) {
            String string2 = this.getPhysicalFromLogicalURI(string);
            if (string2 == null) {
                throw new ModelException("Cannot map logical URI '" + string + "' to physical URI.");
            }
            model = this.getModelPhysical(string2);
        }
        return model;
    }

    public synchronized void removeModel(Model model) throws ModelException {
        this.m_physicalURItoModel.remove(model.getPhysicalURI());
        this.m_logicalURItoModel.remove(model.getLogicalURI());
    }

    public synchronized boolean isModelLoadedPhysical(String string) {
        return this.m_physicalURItoModel.containsKey(string);
    }

    public synchronized boolean isModelLoadedLogical(String string) {
        return this.m_logicalURItoModel.containsKey(string);
    }
}

