/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import edu.unika.aifb.rdf.api.model.Literal;
import edu.unika.aifb.rdf.api.model.ModelException;
import edu.unika.aifb.rdf.api.model.NodeFactory;
import edu.unika.aifb.rdf.api.model.RDFNode;
import edu.unika.aifb.rdf.api.model.Resource;
import edu.unika.aifb.rdf.api.model.Statement;
import edu.unika.aifb.rdf.mainmemory.CompleteLiteralImpl;
import edu.unika.aifb.rdf.mainmemory.LiteralImpl;
import edu.unika.aifb.rdf.mainmemory.ResourceImpl;
import edu.unika.aifb.rdf.mainmemory.StatementImpl;
import edu.unika.aifb.rdf.mainmemory.WeakValueHashMap;
import java.util.Map;

public class NodeFactoryImpl
implements NodeFactory {
    protected Map m_resources = new WeakValueHashMap();
    protected Map m_literals = new WeakValueHashMap();

    public synchronized Resource createResource(String string) throws ModelException {
        Resource resource = (Resource)this.m_resources.get(string);
        if (resource == null) {
            resource = new ResourceImpl(string);
            this.m_resources.put(string, resource);
        }
        return resource;
    }

    public synchronized Resource createResource(String string, String string2) throws ModelException {
        String string3 = string == null ? string2 : string + string2;
        return this.createResource(string3);
    }

    public synchronized Literal createLiteral(String string) {
        Literal literal = (Literal)this.m_literals.get(string);
        if (literal == null) {
            literal = new LiteralImpl(string);
            this.m_literals.put(string, literal);
        }
        return literal;
    }

    public synchronized Literal createLiteral(String string, String string2, String string3) throws ModelException {
        if ((string2 == null || "Literal".equals(string2)) && string3 == null) {
            return this.createLiteral(string);
        }
        String string4 = string + "!" + string2 + "!" + string3;
        Literal literal = (Literal)this.m_literals.get(string4);
        if (literal == null) {
            literal = new CompleteLiteralImpl(string, string2, string3);
            this.m_literals.put(string4, literal);
        }
        return literal;
    }

    public Statement createStatement(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        return new StatementImpl(resource, resource2, rDFNode);
    }

    public Resource createOrdinal(int n) throws ModelException {
        if (n < 1) {
            throw new IllegalArgumentException("Attempt to construct invalid ordinal resource");
        }
        return this.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "_" + n);
    }

    public Literal createLiteral(boolean bl) throws ModelException {
        return this.createLiteral(String.valueOf(bl));
    }

    public Literal createLiteral(byte by) throws ModelException {
        return this.createLiteral(String.valueOf(by));
    }

    public Literal createLiteral(char c) throws ModelException {
        return this.createLiteral(String.valueOf(c));
    }

    public Literal createLiteral(short s) throws ModelException {
        return this.createLiteral(String.valueOf(s));
    }

    public Literal createLiteral(int n) throws ModelException {
        return this.createLiteral(String.valueOf(n));
    }

    public Literal createLiteral(long l) throws ModelException {
        return this.createLiteral(String.valueOf(l));
    }

    public Literal createLiteral(float f) throws ModelException {
        return this.createLiteral(String.valueOf(f));
    }

    public Literal createLiteral(double d) throws ModelException {
        return this.createLiteral(String.valueOf(d));
    }
}

