/*
 * Decompiled with CFR 0.152.
 */
package edu.unika.aifb.rdf.mainmemory;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    public WeakValueHashMap(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public WeakValueHashMap(int n) {
        this.hash = new HashMap(n);
    }

    public WeakValueHashMap() {
        this.hash = new HashMap();
    }

    public WeakValueHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    public boolean containsKey(Object object) {
        return this.hash.containsKey(object);
    }

    public Object get(Object object) {
        WeakValue weakValue = (WeakValue)this.hash.get(object);
        if (weakValue == null) {
            return null;
        }
        return weakValue.get();
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        WeakValue weakValue = this.hash.put(object, object2 == null ? null : new WeakValue(object2, this.queue, object));
        if (weakValue == null) {
            return null;
        }
        return weakValue.get();
    }

    public Object remove(Object object) {
        this.processQueue();
        WeakValue weakValue = (WeakValue)this.hash.remove(object);
        if (weakValue == null) {
            return null;
        }
        return weakValue.get();
    }

    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new WeakEntrySet();
        }
        return this.entrySet;
    }

    private void processQueue() {
        WeakValue weakValue;
        while ((weakValue = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(weakValue.key);
        }
    }

    private class WeakEntrySet
    extends AbstractSet {
        protected Set hashEntrySet;

        private WeakEntrySet() {
            this.hashEntrySet = WeakValueHashMap.this.hash.entrySet();
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Map.Entry next;
                {
                    this.hashIterator = hashEntrySet.iterator();
                    this.next = this.advance();
                }

                public boolean hasNext() {
                    return this.next != null;
                }

                public Object next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry entry = this.next;
                    this.next = this.advance();
                    return entry;
                }

                public void remove() {
                    this.hashIterator.remove();
                }

                protected Map.Entry advance() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        WeakValue weakValue = (WeakValue)entry.getValue();
                        Object var3_3 = null;
                        if (weakValue != null) {
                            Object t = weakValue.get();
                            var3_3 = t;
                            if (t == null) continue;
                        }
                        return new WeakEntry(entry, var3_3);
                    }
                    return null;
                }
            };
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.hashEntrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                WeakValue weakValue = (WeakValue)entry.getValue();
                if (weakValue != null && weakValue.get() == null) continue;
                ++n;
            }
            return n;
        }

        public boolean remove(Object object) {
            WeakValueHashMap.this.processQueue();
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            WeakValue weakValue = (WeakValue)entry.getValue();
            Object var5_5 = weakValue == null ? null : weakValue.get();
            Object v = WeakValueHashMap.this.hash.get(k);
            if (v == null ? var5_5 == null && WeakValueHashMap.this.hash.containsKey(k) : v.equals(var5_5)) {
                WeakValueHashMap.this.hash.remove(k);
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.hashEntrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                WeakValue weakValue = (WeakValue)entry.getValue();
                Object object = null;
                if (weakValue != null) {
                    Object t = weakValue.get();
                    object = t;
                    if (t == null) continue;
                }
                n += entry.getKey().hashCode() ^ (object == null ? 0 : object.hashCode());
            }
            return n;
        }
    }

    private static class WeakEntry
    implements Map.Entry {
        protected Map.Entry entry;
        protected Object value;

        protected WeakEntry(Map.Entry entry, Object object) {
            this.entry = entry;
            this.value = object;
        }

        public Object getKey() {
            return this.entry.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            this.value = object;
            return this.entry.setValue(object);
        }

        private static boolean objectEquals(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return WeakEntry.objectEquals(this.getKey(), entry.getKey()) && WeakEntry.objectEquals(this.getValue(), entry.getValue());
        }

        public int hashCode() {
            Object object = this.getKey();
            return (object == null ? 0 : object.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private static class WeakValue
    extends WeakReference {
        public Object key;

        public WeakValue(Object object, ReferenceQueue referenceQueue, Object object2) {
            super(object, referenceQueue);
            this.key = object2;
        }
    }
}

