/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.fixing;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFSVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFVocabularyAdapter;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.validation.OWLValidationConstants;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import org.xml.sax.SAXException;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class Fixer
implements OWLValidationConstants {
    public static int CLASSES = 0;
    public static int DATATYPES = 1;
    public static int INDIVIDUALS = 2;
    public static int OBJECT_PROPERTIES = 3;
    public static int DATATYPE_PROPERTIES = 4;
    public static int ANNOTATION_PROPERTIES = 5;
    private static int UNTYPED_COUNT = 6;
    private URI uri;
    private boolean result;
    private int level;
    private boolean owlFull;
    private boolean schemaImportUsed;
    private boolean dcUsed;
    private Set[] untyped;
    private OWLOntology ontology;
    private SpeciesValidator speciesValidator;
    private Strategy strategy;
    private static OWLVocabularyAdapter owlV = OWLVocabularyAdapter.INSTANCE;
    private static RDFVocabularyAdapter rdfV = RDFVocabularyAdapter.INSTANCE;
    private static RDFSVocabularyAdapter rdfsV = RDFSVocabularyAdapter.INSTANCE;
    private static String DC = "http://purl.org/dc/elements/1.1";
    private PrintWriter reportWriter;
    private PrintWriter messageWriter;
    public static boolean[][] options = new boolean[][]{{false, false, false, false}, {true, false, false, false}, {false, true, false, false}, {true, true, false, false}, {false, false, true, false}, {false, false, false, true}, {false, true, true, false}, {false, true, false, true}};

    public Fixer() throws OWLException {
        this.resetFixes();
        this.strategy = new Strategy();
        this.speciesValidator = new SpeciesValidator();
        SpeciesValidatorReporter reporter = new SpeciesValidatorReporter(){

            public void message(String str) {
            }

            public void explain(int l, int c, String str) {
            }

            public void ontology(OWLOntology ontology) {
            }

            public void done(String level) {
            }
        };
        this.speciesValidator.setReporter(reporter);
        this.reportWriter = null;
    }

    public Set[] getUntyped() {
        return this.untyped;
    }

    private void resetFixes() {
        this.untyped = new Set[UNTYPED_COUNT];
        for (int i = 0; i < UNTYPED_COUNT; ++i) {
            this.untyped[i] = new HashSet();
        }
    }

    public void setStrategy(Strategy s) {
        this.strategy = s;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setReportWriter(PrintWriter pw) {
        this.reportWriter = pw;
    }

    public void setMessageWriter(PrintWriter pw) {
        this.messageWriter = pw;
    }

    public String status() {
        StringBuffer sb = new StringBuffer();
        sb.append("================================================\n");
        sb.append(this.strategy.toString());
        sb.append("\t" + this.getFixes().size() + " fixes to be applied\n");
        sb.append("================================================");
        return sb.toString();
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean getDCUsed() {
        return this.dcUsed;
    }

    public void parse() throws OWLException {
        this.owlFull = false;
        this.resetFixes();
        OWLRDFParser parser = new OWLRDFParser();
        parser.setConnection(OWLManager.getOWLConnection());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (this.strategy.laxSchema) {
            options.put("ignoreSchemaImports", new Boolean(true));
        }
        if (this.strategy.laxSameAs) {
            options.put("fixSameAs", new Boolean(true));
        }
        parser.setOptions(options);
        OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

            public void owlFullConstruct(int code, String message) throws SAXException {
                Fixer.this.owlFull = true;
            }

            public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                Fixer.this.owlFull = true;
                if (!Fixer.this.applyFix(code, message, obj)) {
                    // empty if block
                }
            }

            public void error(String message) throws SAXException {
                throw new SAXException(message.toString());
            }

            public void warning(String message) throws SAXException {
            }
        };
        parser.setOWLRDFErrorHandler(handler);
        this.ontology = parser.parseOntology(this.uri);
    }

    public void warning(String str) {
        this.message("WARNING: " + str);
    }

    public boolean owlFull() {
        return this.owlFull;
    }

    public boolean fixable() {
        return !this.getFixes().isEmpty();
    }

    public Set getFixes() {
        Object obj;
        HashSet<String> fs = new HashSet<String>();
        String triple = null;
        Iterator it = this.untyped[CLASSES].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(owlV.getClass_(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        it = this.untyped[INDIVIDUALS].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(owlV.getThing(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        it = this.untyped[DATATYPES].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(rdfsV.getDatatype(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        it = this.untyped[OBJECT_PROPERTIES].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(owlV.getObjectProperty(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        it = this.untyped[DATATYPE_PROPERTIES].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(owlV.getDatatypeProperty(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        it = this.untyped[ANNOTATION_PROPERTIES].iterator();
        while (it.hasNext()) {
            obj = it.next();
            triple = this.typeTriple(owlV.getAnnotationProperty(), obj);
            if (triple == null) continue;
            fs.add(triple);
        }
        return fs;
    }

    public String summary() {
        Object obj;
        Iterator it;
        StringBuffer sb = new StringBuffer();
        sb.append("\t=== Type Triples Required ===\n");
        if (!this.untyped[CLASSES].isEmpty()) {
            sb.append("\tClasses:\n");
            it = this.untyped[CLASSES].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        if (!this.untyped[INDIVIDUALS].isEmpty()) {
            sb.append("\tIndividuals:\n");
            it = this.untyped[INDIVIDUALS].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        if (!this.untyped[DATATYPES].isEmpty()) {
            sb.append("\tDatatypes:\n");
            it = this.untyped[DATATYPES].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        if (!this.untyped[OBJECT_PROPERTIES].isEmpty()) {
            sb.append("\tObject Properties:\n");
            it = this.untyped[OBJECT_PROPERTIES].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        if (!this.untyped[DATATYPE_PROPERTIES].isEmpty()) {
            sb.append("\tDatatype Properties:\n");
            it = this.untyped[DATATYPE_PROPERTIES].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        if (!this.untyped[ANNOTATION_PROPERTIES].isEmpty()) {
            sb.append("\tAnnotation Properties:\n");
            it = this.untyped[ANNOTATION_PROPERTIES].iterator();
            while (it.hasNext()) {
                obj = it.next();
                sb.append("\t" + obj + "\n");
            }
        }
        return sb.toString();
    }

    public void checkSchemaImports() throws OWLException {
        Set allOntologies = OntologyHelper.importClosure((OWLOntology)this.ontology);
        this.schemaImportUsed = false;
        Iterator it = allOntologies.iterator();
        while (it.hasNext()) {
            OWLOntology imported = (OWLOntology)it.next();
            String url = imported.getURI().toString();
            String url2 = url + "#";
            if (!url.equals("http://www.w3.org/2002/07/owl#") && !url.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && !url.equals("http://www.w3.org/2000/01/rdf-schema#") && !url2.equals("http://www.w3.org/2002/07/owl#") && !url2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && !url2.equals("http://www.w3.org/2000/01/rdf-schema#")) continue;
            this.schemaImportUsed = true;
            this.message("IMPORT: " + url);
        }
    }

    private boolean containerMembershipProperty(Object obj) {
        String str = obj.toString();
        String frag = str.substring(str.indexOf(35) + 1);
        return frag.matches("_\\d+");
    }

    private boolean seqBagOrAlt(Object obj) {
        String str = obj.toString();
        String frag = str.substring(str.indexOf(35) + 1);
        return frag.equals("Bag") || frag.equals("Alt") || frag.equals("Seq");
    }

    private boolean applyFix(int code, String message, Object obj) {
        if (obj != null && (obj.toString().startsWith("http://www.w3.org/2002/07/owl#") || obj.toString().startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#") && !this.containerMembershipProperty(obj) && !this.seqBagOrAlt(obj) || obj.toString().startsWith("http://www.w3.org/2000/01/rdf-schema#"))) {
            return false;
        }
        Object triple = null;
        switch (code) {
            case 2002: {
                if (this.strategy.fixOthers && obj != null) {
                    this.untyped[CLASSES].add(obj);
                    return true;
                }
                return false;
            }
            case 2006: {
                if (this.strategy.fixOthers && obj != null) {
                    this.untyped[DATATYPES].add(obj);
                    return true;
                }
                return false;
            }
            case 2005: {
                return false;
            }
            case 2024: {
                if (this.strategy.fixOthers && obj != null) {
                    this.untyped[OBJECT_PROPERTIES].add(obj);
                    return true;
                }
                return false;
            }
            case 2023: {
                if (obj.toString().startsWith(DC) && this.strategy.fixDC) {
                    this.dcUsed = true;
                    if (obj != null) {
                        this.untyped[ANNOTATION_PROPERTIES].add(obj);
                        return true;
                    }
                }
                if (this.strategy.fixOthers && obj != null) {
                    this.untyped[DATATYPE_PROPERTIES].add(obj);
                    return true;
                }
                return false;
            }
            case 2004: {
                if (obj != null && (obj.toString().equals(owlV.getThing()) || obj.toString().equals(owlV.getNothing())) && obj != null) {
                    this.untyped[CLASSES].add(obj);
                    return true;
                }
                if (this.strategy.fixOthers && obj != null) {
                    this.untyped[INDIVIDUALS].add(obj);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private String typeTriple(String type, Object obj) {
        StringBuffer sb = new StringBuffer();
        URI objURI = null;
        if (obj != null) {
            try {
                objURI = (URI)obj;
            }
            catch (ClassCastException ex) {
                return null;
            }
            if (objURI == null) {
                return null;
            }
            String str = objURI.toString();
            str = str.replaceAll("&", "&amp;");
            sb.append(" <rdf:Description rdf:about='" + str + "'>\n");
            sb.append("  <rdf:type rdf:resource='" + type + "'/>\n");
            sb.append(" </rdf:Description>\n");
            return sb.toString();
        }
        return null;
    }

    public int applyStrategy(URI uri, String output) throws OWLException, IOException {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        this.resetFixes();
        options.put("ignoreSchemaImports", new Boolean(this.strategy.laxSchema));
        options.put("fixSameAs", new Boolean(this.strategy.laxSameAs));
        this.speciesValidator.setOptions(options);
        this.message("Validating");
        this.speciesValidator.setConnection(OWLManager.getOWLConnection());
        if (this.speciesValidator.isOWLDL(uri)) {
            this.message("Validation Succeeded");
            this.message(this.strategy.toString());
            this.report(uri, this.strategy, null, false);
            return 0;
        }
        this.message("Fixing");
        this.setURI(uri);
        this.parse();
        if (this.fixable()) {
            this.message("Fixer thinks it can fix " + uri);
            File outputFile = null;
            if (output == null) {
                outputFile = File.createTempFile("fixer", ".owl");
                outputFile.deleteOnExit();
            } else {
                outputFile = new File(output);
            }
            FileWriter fw = new FileWriter(outputFile);
            PrintWriter pw = new PrintWriter(fw);
            pw.print("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
            pw.print("<rdf:RDF xmlns:owl='http://www.w3.org/2002/07/owl#'\n");
            pw.print(" xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n");
            pw.print(" xmlns:rdfs='http://www.w3.org/2000/01/rdf-schema#'\n");
            pw.print(" xmlns:xsd='http://www.w3.org/2000/10/XMLSchema#'>\n");
            pw.print(" <owl:Ontology rdf:about=''>\n");
            pw.print("  <owl:imports>\n");
            pw.print("    <owl:Ontology rdf:about='" + this.getURI() + "'/>\n");
            pw.print("  </owl:imports>\n");
            pw.print(" </owl:Ontology>\n");
            pw.print("\n");
            Iterator it = this.getFixes().iterator();
            while (it.hasNext()) {
                pw.print(it.next());
            }
            pw.print("\n");
            pw.print("</rdf:RDF>\n");
            pw.print("\n");
            fw.close();
            this.message("Validating " + outputFile.toURI());
            this.speciesValidator.setConnection(OWLManager.getOWLConnection());
            if (this.speciesValidator.isOWLDL(outputFile.toURI())) {
                this.message("***** FIX SUCCEEDED *****");
                this.message("Fixer Options:");
                this.message(this.status());
                this.message("Validation Options:");
                this.message("\tSchema Ignore\t" + (this.strategy.laxSchema ? "YES" : "NO"));
                this.message("\tSameAs fix\t" + (this.strategy.laxSameAs ? "YES" : "NO"));
                this.message("***** FIX SUCCEEDED *****");
                this.report(uri, this.strategy, output, true);
                return 0;
            }
            this.message("Fix Failed");
        } else {
            this.message("Fixer does not think it can fix");
        }
        return -1;
    }

    public void message(String message) {
        if (this.messageWriter != null) {
            this.messageWriter.println(message);
        }
    }

    public void report(String message) {
        if (this.reportWriter != null) {
            this.reportWriter.println(message);
        }
    }

    public void report(URI uri, Strategy strategy, String output, boolean added) {
        if (this.reportWriter != null) {
            this.reportWriter.println("Validation of " + uri + " was successful");
            this.reportWriter.println(strategy.toString());
            if (added) {
                this.reportWriter.println(this.summary());
                if (output != null) {
                    this.reportWriter.println("\tThese were written to\n\t\t" + output);
                }
            }
        }
    }

    public static void usage() {
        System.out.println("usage: Fixer [options] URI");
        System.out.println("\t--help -? \n\t\tPrint this message");
        System.out.println("\t--lax -l \n\t\tIf validation fails, try and parse with lax options.");
        System.out.println("\t--fix -f \n\t\tIf validation fails, try and fix and then check the fixed ontology.");
        System.out.println("\t--output -o \n\t\tWrite fixed ontology to file");
    }

    public Strategy newStrategy(boolean[] bs) {
        Strategy st = new Strategy();
        st.fixDC = bs[0];
        st.fixOthers = bs[1];
        st.laxSchema = bs[2];
        st.laxSameAs = bs[3];
        return st;
    }

    public class Strategy {
        public boolean fixDC;
        public boolean fixOthers;
        public boolean laxSchema;
        public boolean laxSameAs;

        private Strategy() {
            this.fixDC = false;
            this.fixOthers = false;
            this.laxSchema = false;
            this.laxSameAs = false;
        }

        private Strategy(boolean[] bs) {
            this.fixDC = bs[0];
            this.fixOthers = bs[1];
            this.laxSchema = bs[2];
            this.laxSameAs = bs[3];
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\tUntyped Fix: \t" + (this.fixOthers ? "YES" : "NO") + "\n");
            sb.append("\tDC Fix: \t" + (this.fixDC ? "YES" : "NO") + "\n");
            sb.append("\tSchema Fix: \t" + (this.laxSchema ? "YES" : "NO") + "\n");
            sb.append("\tSameAsFix: \t" + (this.laxSameAs ? "YES" : "NO") + "\n");
            return sb.toString();
        }
    }
}

