/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicCell;
import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.MEnumeration;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.align.Relation;
import org.xml.sax.ContentHandler;

public class BasicAlignment
implements Alignment {
    protected Object onto1 = null;
    protected Object onto2 = null;
    protected static boolean STRICT_IMPLEMENTATION = false;
    protected int debug = 0;
    protected String level = "0";
    protected String type = "**";
    protected Hashtable hash1 = new Hashtable();
    protected Hashtable hash2 = new Hashtable();
    protected long time = 0L;
    protected Parameters extensions = new BasicParameters();
    protected URI uri1 = null;
    protected URI uri2 = null;

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Alignment)this);
    }

    public BasicAlignment() {
        this.setExtension("method", this.getClass().getName());
    }

    public void init(Object object, Object object2, Object object3) throws AlignmentException {
        this.onto1 = object;
        this.onto2 = object2;
    }

    public void init(Object object, Object object2) throws AlignmentException {
        this.init(object, object2, null);
    }

    public int nbCells() {
        int n = 0;
        Enumeration enumeration = this.hash1.elements();
        while (enumeration.hasMoreElements()) {
            n += ((HashSet)enumeration.nextElement()).size();
        }
        return n;
    }

    public Object getOntology1() {
        return this.onto1;
    }

    public Object getOntology2() {
        return this.onto2;
    }

    public URI getOntology1URI() throws AlignmentException {
        if (this.onto1 instanceof URI) {
            return (URI)this.onto1;
        }
        throw new AlignmentException("Cannot find URI for " + this.onto1);
    }

    public URI getOntology2URI() throws AlignmentException {
        if (this.onto2 instanceof URI) {
            return (URI)this.onto2;
        }
        throw new AlignmentException("Cannot find URI for " + this.onto2);
    }

    public void setOntology1(Object object) throws AlignmentException {
        this.onto1 = object;
    }

    public void setOntology2(Object object) throws AlignmentException {
        this.onto2 = object;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public String getLevel() {
        return this.level;
    }

    public URI getFile1() {
        return this.uri1;
    }

    public void setFile1(URI uRI) {
        this.uri1 = uRI;
    }

    public URI getFile2() {
        return this.uri2;
    }

    public void setFile2(URI uRI) {
        this.uri2 = uRI;
    }

    public Parameters getExtensions() {
        return this.extensions;
    }

    public void setExtension(String string, String string2) {
        this.extensions.setParameter(string, (Object)string2);
    }

    public String getExtension(String string) {
        return (String)this.extensions.getParameter(string);
    }

    public Enumeration getElements() {
        return new MEnumeration(this.hash1);
    }

    public ArrayList getArrayElements() {
        ArrayList<BasicCell> arrayList = new ArrayList<BasicCell>();
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            arrayList.add((BasicCell)enumeration.nextElement());
        }
        return arrayList;
    }

    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        Cell cell = this.createCell(string, object, object2, relation, d);
        this.addCell(cell);
        return cell;
    }

    public Cell addAlignCell(Object object, Object object2, String string, double d) throws AlignmentException {
        return this.addAlignCell(null, object, object2, BasicRelation.createRelation("="), d);
    }

    public Cell addAlignCell(Object object, Object object2) throws AlignmentException {
        return this.addAlignCell(null, object, object2, BasicRelation.createRelation("="), 1.0);
    }

    public Cell createCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        return new BasicCell(string, object, object2, relation, d);
    }

    protected void addCell(Cell cell) throws AlignmentException {
        HashSet hashSet;
        boolean bl = false;
        HashSet<Cell> hashSet2 = (HashSet<Cell>)this.hash1.get(cell.getObject1());
        if (hashSet2 != null) {
            hashSet = hashSet2.iterator();
            while (!bl && hashSet.hasNext()) {
                if (!cell.equals((Cell)((BasicCell)hashSet.next()))) continue;
                bl = true;
            }
            if (!bl) {
                hashSet2.add(cell);
            }
        } else {
            hashSet2 = new HashSet<Cell>();
            hashSet2.add(cell);
            this.hash1.put(cell.getObject1(), hashSet2);
        }
        bl = false;
        hashSet = (HashSet)this.hash2.get(cell.getObject2());
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (!bl && iterator.hasNext()) {
                if (!cell.equals((Cell)((BasicCell)iterator.next()))) continue;
                bl = true;
            }
            if (!bl) {
                hashSet.add(cell);
            }
        } else {
            hashSet = new HashSet();
            hashSet.add(cell);
            this.hash2.put(cell.getObject2(), hashSet);
        }
    }

    public Set getAlignCells1(Object object) throws AlignmentException {
        return (HashSet)this.hash1.get(object);
    }

    public Set getAlignCells2(Object object) throws AlignmentException {
        return (HashSet)this.hash2.get(object);
    }

    public Cell getAlignCell1(Object object) throws AlignmentException {
        if (STRICT_IMPLEMENTATION) {
            throw new AlignmentException("getAlignCell1: deprecated (use getAlignCells1 instead)");
        }
        Set set = (Set)this.hash1.get(object);
        Cell cell = null;
        double d = 0.0;
        if (set != null) {
            for (Cell cell2 : set) {
                double d2 = cell2.getStrength();
                if (!(d2 > d)) continue;
                d = d2;
                cell = cell2;
            }
        }
        return cell;
    }

    public Cell getAlignCell2(Object object) throws AlignmentException {
        if (STRICT_IMPLEMENTATION) {
            throw new AlignmentException("getAlignCell2: deprecated (use getAlignCells2 instead)");
        }
        Set set = (Set)this.hash2.get(object);
        Cell cell = null;
        double d = 0.0;
        if (set != null) {
            for (Cell cell2 : set) {
                double d2 = cell2.getStrength();
                if (!(d2 > d)) continue;
                d = d2;
                cell = cell2;
            }
        }
        return cell;
    }

    public Object getAlignedObject1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getObject2();
        }
        return null;
    }

    public Object getAlignedObject2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getObject1();
        }
        return null;
    }

    public Relation getAlignedRelation1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getRelation();
        }
        return null;
    }

    public Relation getAlignedRelation2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getRelation();
        }
        return null;
    }

    public double getAlignedStrength1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getStrength();
        }
        return 0.0;
    }

    public double getAlignedStrength2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getStrength();
        }
        return 0.0;
    }

    public void removeAlignCell(Cell cell) throws AlignmentException {
        HashSet hashSet = (HashSet)this.hash1.get(cell.getObject1());
        HashSet hashSet2 = (HashSet)this.hash2.get(cell.getObject2());
        hashSet.remove(cell);
        hashSet2.remove(cell);
        if (hashSet.isEmpty()) {
            this.hash1.remove(cell.getObject1());
        }
        if (hashSet2.isEmpty()) {
            this.hash2.remove(cell.getObject2());
        }
    }

    public void cut2(double d) throws AlignmentException {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (!(cell.getStrength() < d)) continue;
            this.removeAlignCell(cell);
        }
    }

    public void cut(double d) throws AlignmentException {
        this.cut("hard", d);
    }

    public void cut(String string, double d) throws AlignmentException {
        if (d > 1.0 || d < 0.0) {
            throw new AlignmentException("Not a percentage or threshold : " + d);
        }
        ArrayList arrayList = this.getArrayElements();
        Collections.sort(arrayList);
        int n = arrayList.size();
        boolean bl = false;
        int n2 = 0;
        if (string.equals("perc")) {
            n2 = new Double((double)n * d).intValue();
        } else if (string.equals("best")) {
            n2 = new Double(d * 100.0).intValue();
        } else {
            double d2;
            if (string.equals("hard")) {
                d2 = d;
            } else if (string.equals("span")) {
                d2 = ((Cell)arrayList.get(0)).getStrength() - d;
            } else if (string.equals("prop")) {
                d2 = ((Cell)arrayList.get(0)).getStrength() * d;
            } else {
                throw new AlignmentException("Not a cut specification : " + string);
            }
            n2 = 0;
            while (n2 < n && !bl) {
                if (((Cell)arrayList.get(n2)).getStrength() < d2) {
                    bl = true;
                    continue;
                }
                ++n2;
            }
        }
        n = n2;
        this.hash1.clear();
        this.hash2.clear();
        for (n2 = 0; n2 < n; ++n2) {
            this.addCell((Cell)arrayList.get(n2));
        }
    }

    public URIAlignment toURIAlignment() throws AlignmentException {
        throw new AlignmentException("[BasicAlignment].toURIAlignment() cannot process");
    }

    public void harden(double d) throws AlignmentException {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            if (cell.getStrength() < d) {
                this.removeAlignCell(cell);
                continue;
            }
            cell.setStrength(1.0);
        }
    }

    public Alignment meet(Alignment alignment) throws AlignmentException {
        BasicAlignment basicAlignment = new BasicAlignment();
        basicAlignment.init(this.onto1, this.onto2);
        return basicAlignment;
    }

    public Alignment join(Alignment alignment) throws AlignmentException {
        BasicAlignment basicAlignment = new BasicAlignment();
        basicAlignment.init(this.onto1, this.onto2);
        return basicAlignment;
    }

    public Alignment compose(Alignment alignment) throws AlignmentException {
        BasicAlignment basicAlignment = new BasicAlignment();
        basicAlignment.init(this.onto1, this.onto2);
        return basicAlignment;
    }

    public Alignment inverse() throws AlignmentException {
        BasicAlignment basicAlignment = new BasicAlignment();
        basicAlignment.init(this.onto2, this.onto1);
        basicAlignment.setFile1(this.getFile2());
        basicAlignment.setFile2(this.getFile1());
        basicAlignment.setType(this.getType());
        basicAlignment.setLevel(this.getLevel());
        Enumeration enumeration = this.extensions.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            basicAlignment.setExtension(string, this.getExtension(string));
        }
        basicAlignment.getExtensions().unsetParameter("id");
        enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            basicAlignment.addCell(((Cell)enumeration.nextElement()).inverse());
        }
        return basicAlignment;
    }

    public void dump(ContentHandler contentHandler) {
    }

    public void ingest(Alignment alignment) throws AlignmentException {
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            this.addCell((Cell)enumeration.nextElement());
        }
    }

    public Object clone() {
        BasicAlignment basicAlignment = new BasicAlignment();
        try {
            basicAlignment.init(this.getOntology1(), this.getOntology2());
        }
        catch (AlignmentException alignmentException) {
            // empty catch block
        }
        basicAlignment.setType(this.getType());
        basicAlignment.setLevel(this.getLevel());
        basicAlignment.setFile1(this.getFile1());
        basicAlignment.setFile2(this.getFile2());
        Enumeration enumeration = this.extensions.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            basicAlignment.setExtension(string, this.getExtension(string));
        }
        basicAlignment.getExtensions().unsetParameter("id");
        try {
            basicAlignment.ingest(this);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return basicAlignment;
    }

    public void render(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        this.accept(alignmentVisitor);
    }

    public void cleanUp() {
    }
}

