/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import java.net.URI;
import java.util.Enumeration;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.align.Relation;
import org.xml.sax.ContentHandler;

public class BasicCell
implements Cell,
Comparable {
    protected String id = null;
    protected String semantics = null;
    protected Object object1 = null;
    protected Object object2 = null;
    protected Relation relation = null;
    protected double strength = 0.0;
    protected Parameters extensions = null;

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Cell)this);
    }

    public BasicCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        this.setId(string);
        this.object1 = object;
        this.object2 = object2;
        this.relation = relation;
        if (d >= 0.0 && d <= 1.0) {
            this.strength = d;
        }
    }

    public boolean equals(Cell cell) {
        if (cell instanceof BasicCell) {
            return this.object1 == cell.getObject1() && this.object2 == cell.getObject2() && this.strength == cell.getStrength() && this.relation.equals(cell.getRelation());
        }
        return false;
    }

    public int compareTo(Object object) {
        if (((Cell)object).getStrength() > this.getStrength()) {
            return 1;
        }
        if (this.getStrength() > ((Cell)object).getStrength()) {
            return -1;
        }
        return 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getSemantics() {
        if (this.semantics != null) {
            return this.semantics;
        }
        return "first-order";
    }

    public void setSemantics(String string) {
        this.semantics = string;
    }

    public Object getObject1() {
        return this.object1;
    }

    public Object getObject2() {
        return this.object2;
    }

    public URI getObject1AsURI() throws AlignmentException {
        if (this.object1 instanceof URI) {
            return (URI)this.object1;
        }
        throw new AlignmentException("Cannot find URI for " + this.object1);
    }

    public URI getObject2AsURI() throws AlignmentException {
        if (this.object2 instanceof URI) {
            return (URI)this.object2;
        }
        throw new AlignmentException("Cannot find URI for " + this.object2);
    }

    public void setObject1(Object object) throws AlignmentException {
        this.object1 = object;
    }

    public void setObject2(Object object) throws AlignmentException {
        this.object2 = object;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public void setRelation(Relation relation) {
        this.relation = relation;
    }

    public double getStrength() {
        return this.strength;
    }

    public void setStrength(double d) {
        this.strength = d;
    }

    public Parameters getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Parameters parameters) {
        this.extensions = parameters;
    }

    public void setExtension(String string, String string2) {
        if (this.extensions == null) {
            this.extensions = new BasicParameters();
        }
        this.extensions.setParameter(string, (Object)string2);
    }

    public String getExtension(String string) {
        if (this.extensions != null) {
            return (String)this.extensions.getParameter(string);
        }
        return null;
    }

    public Cell inverse() throws AlignmentException {
        BasicCell basicCell = new BasicCell(null, this.object2, this.object1, this.relation.inverse(), this.strength);
        if (this.extensions != null) {
            Enumeration enumeration = this.extensions.getNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                basicCell.setExtension(string, this.getExtension(string));
            }
        }
        basicCell.getExtensions().unsetParameter("id");
        return basicCell;
    }

    public void dump(ContentHandler contentHandler) {
    }
}

