/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.ConcatenatedIterator;
import fr.inrialpes.exmo.align.impl.HungarianAlgorithm;
import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.OWLAPICell;
import fr.inrialpes.exmo.align.impl.Similarity;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public class DistanceAlignment
extends OWLAPIAlignment
implements AlignmentProcess {
    Similarity sim;

    public DistanceAlignment() {
    }

    public DistanceAlignment(OWLOntology oWLOntology, OWLOntology oWLOntology2) {
    }

    public void setSimilarity(Similarity similarity) {
        this.sim = similarity;
    }

    public Similarity getSimilarity() {
        return this.sim;
    }

    public void addAlignDistanceCell(Object object, Object object2, String string, double d) throws AlignmentException {
        this.addAlignCell(object, object2, string, 1.0 - d);
    }

    public double getAlignedDistance1(Object object) throws AlignmentException {
        return 1.0 - this.getAlignedStrength1(object);
    }

    public double getAlignedDistance2(Object object) throws AlignmentException {
        return 1.0 - this.getAlignedStrength2(object);
    }

    public void align(Alignment alignment, Parameters parameters) throws AlignmentException {
        this.loadInit(alignment);
        if (parameters.getParameter("type") != null) {
            this.setType((String)parameters.getParameter("type"));
        } else {
            this.setType("11");
        }
        if (this.sim == null) {
            throw new AlignmentException("DistanceAlignment: requires a similarity measure");
        }
        this.sim.initialize((OWLOntology)this.getOntology1(), (OWLOntology)this.getOntology2(), this.init);
        this.sim.compute(parameters);
        if (parameters.getParameter("printMatrix") != null) {
            this.printDistanceMatrix(parameters);
        }
        this.extract(this.getType(), parameters);
    }

    public void printDistanceMatrix(Parameters parameters) {
        System.out.println("\\documentclass{article}\n");
        System.out.println("\\usepackage{graphics}\n");
        System.out.println("\\begin{document}\n");
        System.out.println("\\begin{figure}");
        this.sim.printClassSimilarityMatrix("tex");
        System.out.println();
        this.sim.printPropertySimilarityMatrix("tex");
        System.out.println("\\caption{Class distance with measure " + (String)parameters.getParameter("stringFunction") + "}");
        System.out.println("\\end{figure}");
        System.out.println("\n\\end{document}");
    }

    @Override
    public void cleanUp() {
        this.sim = null;
    }

    public Alignment extract(String string, Parameters parameters) throws AlignmentException {
        double d = 0.0;
        if (parameters.getParameter("threshold") != null) {
            d = (Double)parameters.getParameter("threshold");
        }
        if (string.equals("?*") || string.equals("1*") || string.equals("?+") || string.equals("1+")) {
            return this.extractqs(d, parameters);
        }
        if (string.equals("??") || string.equals("1?") || string.equals("?1") || string.equals("11")) {
            return this.extractqq(d, parameters);
        }
        if (string.equals("*?") || string.equals("+?") || string.equals("*1") || string.equals("+1")) {
            return this.extractqs(d, parameters);
        }
        if (string.equals("**") || string.equals("+*") || string.equals("*+") || string.equals("++")) {
            return this.extractqs(d, parameters);
        }
        throw new AlignmentException("Unknown alignment type: " + string);
    }

    public Alignment extractqs(double d, Parameters parameters) {
        double d2 = 0.0;
        boolean bl = false;
        double d3 = 0.0;
        try {
            ConcatenatedIterator concatenatedIterator;
            ConcatenatedIterator concatenatedIterator2 = new ConcatenatedIterator(((OWLOntology)this.onto1).getObjectProperties().iterator(), ((OWLOntology)this.onto1).getDataProperties().iterator());
            while (concatenatedIterator2.hasNext()) {
                OWLProperty oWLProperty = (OWLProperty)concatenatedIterator2.next();
                bl = false;
                d2 = d;
                d3 = 0.0;
                Object object = null;
                concatenatedIterator = new ConcatenatedIterator(((OWLOntology)this.onto2).getObjectProperties().iterator(), ((OWLOntology)this.onto2).getDataProperties().iterator());
                while (concatenatedIterator.hasNext()) {
                    OWLProperty oWLProperty2 = (OWLProperty)concatenatedIterator.next();
                    d3 = 1.0 - this.sim.getPropertySimilarity(oWLProperty, oWLProperty2);
                    if (!(d3 > d2)) continue;
                    bl = true;
                    d2 = d3;
                    object = oWLProperty2;
                }
                if (!bl) continue;
                this.addAlignCell(oWLProperty, object, "=", d2);
            }
            for (Object object : ((OWLOntology)this.onto1).getClasses()) {
                bl = false;
                d2 = d;
                d3 = 0.0;
                concatenatedIterator = null;
                for (OWLClass oWLClass : ((OWLOntology)this.onto2).getClasses()) {
                    d3 = 1.0 - this.sim.getClassSimilarity((OWLClass)object, oWLClass);
                    if (!(d3 > d2)) continue;
                    bl = true;
                    d2 = d3;
                    concatenatedIterator = oWLClass;
                }
                if (!bl) continue;
                this.addAlignCell(object, concatenatedIterator, "=", d2);
            }
            if (parameters.getParameter("noinst") == null) {
                for (Object object : ((OWLOntology)this.onto1).getIndividuals()) {
                    if (object.getURI() == null) continue;
                    bl = false;
                    d2 = d;
                    d3 = 0.0;
                    concatenatedIterator = null;
                    for (OWLClass oWLClass : ((OWLOntology)this.onto2).getIndividuals()) {
                        if (oWLClass.getURI() == null || !((d3 = 1.0 - this.sim.getIndividualSimilarity((OWLIndividual)object, (OWLIndividual)oWLClass)) > d2)) continue;
                        bl = true;
                        d2 = d3;
                        concatenatedIterator = oWLClass;
                    }
                    if (!bl) continue;
                    this.addAlignCell(object, concatenatedIterator, "=", d2);
                }
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return this;
    }

    public Alignment extractqq(double d, Parameters parameters) {
        int n;
        OWLClass[] oWLClassArray;
        OWLClass[] oWLClassArray2;
        double[][] dArray;
        int n2;
        int n3;
        try {
            n3 = ((OWLOntology)this.onto1).getClasses().size();
            n2 = ((OWLOntology)this.onto2).getClasses().size();
            dArray = new double[n3][n2];
            oWLClassArray2 = new OWLClass[n3];
            oWLClassArray = new OWLClass[n2];
            n = 0;
            Iterator iterator = ((OWLOntology)this.onto1).getClasses().iterator();
            while (iterator.hasNext()) {
                oWLClassArray2[n] = (OWLClass)iterator.next();
                ++n;
            }
            int n4 = 0;
            Object object = ((OWLOntology)this.onto2).getClasses().iterator();
            while (object.hasNext()) {
                oWLClassArray[n4] = (OWLClass)object.next();
                ++n4;
            }
            for (n = 0; n < n3; ++n) {
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n][n4] = 1.0 - this.sim.getClassSimilarity(oWLClassArray2[n], oWLClassArray[n4]);
                }
            }
            object = HungarianAlgorithm.hgAlgorithm(dArray, "max");
            for (n = 0; n < ((Object)object).length; ++n) {
                double d2 = 1.0 - this.sim.getClassSimilarity(oWLClassArray2[object[n][0]], oWLClassArray[object[n][1]]);
                if (!(d2 > d)) continue;
                this.addCell(new OWLAPICell((String)null, (OWLEntity)oWLClassArray2[object[n][0]], (OWLEntity)oWLClassArray[object[n][1]], BasicRelation.createRelation("="), d2));
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        try {
            n3 = ((OWLOntology)this.onto1).getDataProperties().size() + ((OWLOntology)this.onto1).getObjectProperties().size();
            n2 = ((OWLOntology)this.onto2).getDataProperties().size() + ((OWLOntology)this.onto2).getObjectProperties().size();
            dArray = new double[n3][n2];
            oWLClassArray2 = new OWLProperty[n3];
            oWLClassArray = new OWLProperty[n2];
            n = 0;
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(((OWLOntology)this.onto1).getObjectProperties().iterator(), ((OWLOntology)this.onto1).getDataProperties().iterator());
            while (concatenatedIterator.hasNext()) {
                oWLClassArray2[n] = (OWLProperty)concatenatedIterator.next();
                ++n;
            }
            int n5 = 0;
            ConcatenatedIterator concatenatedIterator2 = new ConcatenatedIterator(((OWLOntology)this.onto2).getObjectProperties().iterator(), ((OWLOntology)this.onto2).getDataProperties().iterator());
            while (concatenatedIterator2.hasNext()) {
                oWLClassArray[n5] = (OWLProperty)concatenatedIterator2.next();
                ++n5;
            }
            for (n = 0; n < n3; ++n) {
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray[n][n5] = 1.0 - this.sim.getPropertySimilarity((OWLProperty)oWLClassArray2[n], (OWLProperty)oWLClassArray[n5]);
                }
            }
            int[][] nArray = HungarianAlgorithm.hgAlgorithm(dArray, "max");
            for (n = 0; n < nArray.length; ++n) {
                double d3 = 1.0 - this.sim.getPropertySimilarity((OWLProperty)oWLClassArray2[nArray[n][0]], (OWLProperty)oWLClassArray[nArray[n][1]]);
                if (!(d3 > d)) continue;
                this.addCell(new OWLAPICell((String)null, (OWLEntity)oWLClassArray2[nArray[n][0]], (OWLEntity)oWLClassArray[nArray[n][1]], BasicRelation.createRelation("="), d3));
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return this;
    }

    public Alignment extractqqNaive(double d, Parameters parameters) {
        OWLProperty oWLProperty32 = null;
        OWLProperty oWLProperty222 = null;
        double d2 = 0.0;
        TreeSet<OWLAPICell> treeSet = new TreeSet<OWLAPICell>(new Comparator(){

            public int compare(Object object, Object object2) throws ClassCastException {
                try {
                    if (object instanceof Cell && object2 instanceof Cell) {
                        if (((Cell)object).getStrength() > ((Cell)object2).getStrength()) {
                            return -1;
                        }
                        if (((Cell)object).getStrength() < ((Cell)object2).getStrength()) {
                            return 1;
                        }
                        if (((OWLEntity)((Cell)object).getObject1()).getURI().getFragment() == null || ((OWLEntity)((Cell)object2).getObject1()).getURI().getFragment() == null) {
                            return -1;
                        }
                        if (((OWLEntity)((Cell)object).getObject1()).getURI().getFragment().compareTo(((OWLEntity)((Cell)object2).getObject1()).getURI().getFragment()) > 0) {
                            return -1;
                        }
                        if (((OWLEntity)((Cell)object).getObject1()).getURI().getFragment().compareTo(((OWLEntity)((Cell)object2).getObject1()).getURI().getFragment()) < 0) {
                            return 1;
                        }
                        if (((OWLEntity)((Cell)object).getObject2()).getURI().getFragment() == null || ((OWLEntity)((Cell)object2).getObject2()).getURI().getFragment() == null) {
                            return -1;
                        }
                        if (((OWLEntity)((Cell)object).getObject2()).getURI().getFragment().compareTo(((OWLEntity)((Cell)object2).getObject2()).getURI().getFragment()) > 0) {
                            return -1;
                        }
                        return 1;
                    }
                    throw new ClassCastException();
                }
                catch (OWLException oWLException) {
                    oWLException.printStackTrace();
                    return 0;
                }
            }
        });
        try {
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(((OWLOntology)this.onto1).getObjectProperties().iterator(), ((OWLOntology)this.onto1).getDataProperties().iterator());
            while (concatenatedIterator.hasNext()) {
                oWLProperty32 = (OWLProperty)concatenatedIterator.next();
                Iterator iterator = new ConcatenatedIterator(((OWLOntology)this.onto2).getObjectProperties().iterator(), ((OWLOntology)this.onto2).getDataProperties().iterator());
                while (((ConcatenatedIterator)iterator).hasNext()) {
                    oWLProperty222 = (OWLProperty)((ConcatenatedIterator)iterator).next();
                    d2 = 1.0 - this.sim.getPropertySimilarity(oWLProperty32, oWLProperty222);
                    if (!(d2 > d)) continue;
                    treeSet.add(new OWLAPICell((String)null, (OWLEntity)oWLProperty32, (OWLEntity)oWLProperty222, BasicRelation.createRelation("="), d2));
                }
            }
            for (OWLProperty oWLProperty32 : ((OWLOntology)this.onto1).getClasses()) {
                for (OWLProperty oWLProperty222 : ((OWLOntology)this.onto2).getClasses()) {
                    d2 = 1.0 - this.sim.getClassSimilarity((OWLClass)oWLProperty32, (OWLClass)oWLProperty222);
                    if (!(d2 > d)) continue;
                    treeSet.add(new OWLAPICell((String)null, (OWLEntity)oWLProperty32, (OWLEntity)oWLProperty222, BasicRelation.createRelation("="), d2));
                }
            }
            if (parameters.getParameter("noinst") == null) {
                for (OWLProperty oWLProperty32 : ((OWLOntology)this.onto1).getIndividuals()) {
                    if (oWLProperty32.getURI() == null) continue;
                    for (OWLProperty oWLProperty222 : ((OWLOntology)this.onto2).getIndividuals()) {
                        if (oWLProperty222.getURI() == null || !((d2 = 1.0 - this.sim.getIndividualSimilarity((OWLIndividual)oWLProperty32, (OWLIndividual)oWLProperty222)) > d)) continue;
                        treeSet.add(new OWLAPICell((String)null, (OWLEntity)oWLProperty32, (OWLEntity)oWLProperty222, BasicRelation.createRelation("="), d2));
                    }
                }
            }
            for (Cell cell : treeSet) {
                oWLProperty32 = (OWLEntity)cell.getObject1();
                oWLProperty222 = (OWLEntity)cell.getObject2();
                if (this.getAlignCells1(oWLProperty32) != null || this.getAlignCells2(oWLProperty222) != null) continue;
                this.addCell(cell);
            }
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        return this;
    }
}

