/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

public class HungarianAlgorithm {
    public static double findLargest(double[][] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(dArray[i][j] > d)) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static double[][] transpose(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray.length];
        for (int i = 0; i < dArray2.length; ++i) {
            for (int j = 0; j < dArray2[i].length; ++j) {
                dArray2[i][j] = dArray[j][i];
            }
        }
        return dArray2;
    }

    public static double[][] copyOf(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[i].length);
        }
        return dArray2;
    }

    public static int[][] hgAlgorithm(double[][] dArray, String string) {
        int n;
        if (dArray.length == 0 || dArray[1].length == 0) {
            return new int[0][0];
        }
        int n2 = Math.max(dArray.length, dArray[0].length);
        double[][] dArray2 = new double[dArray.length][n2];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            for (n = 0; n < dArray3.length; ++n) {
                dArray2[i][n] = dArray[i][n];
            }
            for (n = dArray3.length; n < n2; ++n) {
                dArray2[i][n] = 0.0;
            }
        }
        if (string.equalsIgnoreCase("max")) {
            double d = HungarianAlgorithm.findLargest(dArray2);
            for (n = 0; n < dArray2.length; ++n) {
                for (int i = 0; i < dArray2[n].length; ++i) {
                    dArray2[n][i] = d - dArray2[n][i];
                }
            }
        }
        double d = HungarianAlgorithm.findLargest(dArray2);
        int[][] nArray = new int[dArray2.length][dArray2[0].length];
        int[] nArray2 = new int[dArray2.length];
        int[] nArray3 = new int[dArray2[0].length];
        int[] nArray4 = new int[2];
        int n3 = 1;
        boolean bl = false;
        while (!bl) {
            switch (n3) {
                case 1: {
                    n3 = HungarianAlgorithm.hg_step1(n3, dArray2);
                    break;
                }
                case 2: {
                    n3 = HungarianAlgorithm.hg_step2(n3, dArray2, nArray, nArray2, nArray3);
                    break;
                }
                case 3: {
                    n3 = HungarianAlgorithm.hg_step3(n3, nArray, nArray3);
                    break;
                }
                case 4: {
                    n3 = HungarianAlgorithm.hg_step4(n3, dArray2, nArray, nArray2, nArray3, nArray4);
                    break;
                }
                case 5: {
                    n3 = HungarianAlgorithm.hg_step5(n3, nArray, nArray2, nArray3, nArray4);
                    break;
                }
                case 6: {
                    n3 = HungarianAlgorithm.hg_step6(n3, dArray2, nArray2, nArray3, d);
                    break;
                }
                case 7: {
                    bl = true;
                }
            }
        }
        int[][] nArray5 = new int[dArray2.length][2];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] != 1) continue;
                nArray5[i][0] = i;
                nArray5[i][1] = j;
            }
        }
        return nArray5;
    }

    public static int hg_step1(int n, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            int n2;
            double d = dArray[i][0];
            for (n2 = 0; n2 < dArray[i].length; ++n2) {
                if (!(d > dArray[i][n2])) continue;
                d = dArray[i][n2];
            }
            for (n2 = 0; n2 < dArray[i].length; ++n2) {
                dArray[i][n2] = dArray[i][n2] - d;
            }
        }
        n = 2;
        return n;
    }

    public static int hg_step2(int n, double[][] dArray, int[][] nArray, int[] nArray2, int[] nArray3) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (dArray[i][j] != 0.0 || nArray3[j] != 0 || nArray2[i] != 0) continue;
                nArray[i][j] = 1;
                nArray3[j] = 1;
                nArray2[i] = 1;
            }
        }
        HungarianAlgorithm.clearCovers(nArray2, nArray3);
        n = 3;
        return n;
    }

    public static int hg_step3(int n, int[][] nArray, int[] nArray2) {
        int n2;
        int n3;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            for (n2 = 0; n2 < nArray[n3].length; ++n2) {
                if (nArray[n3][n2] != 1) continue;
                nArray2[n2] = 1;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n3 += nArray2[n2];
        }
        n = n3 >= nArray.length ? 7 : 4;
        return n;
    }

    public static int hg_step4(int n, double[][] dArray, int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[2];
        boolean bl = false;
        while (!bl) {
            if ((nArray5 = HungarianAlgorithm.findUncoveredZero(nArray5, dArray, nArray2, nArray3))[0] == -1) {
                bl = true;
                n = 6;
                continue;
            }
            nArray[nArray5[0]][nArray5[1]] = 2;
            boolean bl2 = false;
            for (int i = 0; i < nArray[nArray5[0]].length; ++i) {
                if (nArray[nArray5[0]][i] != 1) continue;
                bl2 = true;
                nArray5[1] = i;
            }
            if (bl2) {
                nArray2[nArray5[0]] = 1;
                nArray3[nArray5[1]] = 0;
                continue;
            }
            nArray4[0] = nArray5[0];
            nArray4[1] = nArray5[1];
            bl = true;
            n = 5;
        }
        return n;
    }

    public static int[] findUncoveredZero(int[] nArray, double[][] dArray, int[] nArray2, int[] nArray3) {
        nArray[0] = -1;
        nArray[1] = 0;
        int n = 0;
        boolean bl = false;
        while (!bl) {
            for (int i = 0; i < dArray[n].length; ++i) {
                if (dArray[n][i] != 0.0 || nArray2[n] != 0 || nArray3[i] != 0) continue;
                nArray[0] = n;
                nArray[1] = i;
                bl = true;
            }
            if (++n < dArray.length) continue;
            bl = true;
        }
        return nArray;
    }

    public static int hg_step5(int n, int[][] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2 = 0;
        int[][] nArray5 = new int[nArray[0].length * nArray.length][2];
        nArray5[n2][0] = nArray4[0];
        nArray5[n2][1] = nArray4[1];
        boolean bl = false;
        while (!bl) {
            int n3 = HungarianAlgorithm.findStarInCol(nArray, nArray5[n2][1]);
            if (n3 >= 0) {
                nArray5[++n2][0] = n3;
                nArray5[n2][1] = nArray5[n2 - 1][1];
            } else {
                bl = true;
            }
            if (bl) continue;
            int n4 = HungarianAlgorithm.findPrimeInRow(nArray, nArray5[n2][0]);
            nArray5[++n2][0] = nArray5[n2 - 1][0];
            nArray5[n2][1] = n4;
        }
        HungarianAlgorithm.convertPath(nArray, nArray5, n2);
        HungarianAlgorithm.clearCovers(nArray2, nArray3);
        HungarianAlgorithm.erasePrimes(nArray);
        n = 3;
        return n;
    }

    public static int findStarInCol(int[][] nArray, int n) {
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][n] != 1) continue;
            n2 = i;
        }
        return n2;
    }

    public static int findPrimeInRow(int[][] nArray, int n) {
        int n2 = -1;
        for (int i = 0; i < nArray[n].length; ++i) {
            if (nArray[n][i] != 2) continue;
            n2 = i;
        }
        return n2;
    }

    public static void convertPath(int[][] nArray, int[][] nArray2, int n) {
        for (int i = 0; i <= n; ++i) {
            nArray[nArray2[i][0]][nArray2[i][1]] = nArray[nArray2[i][0]][nArray2[i][1]] == 1 ? 0 : 1;
        }
    }

    public static void erasePrimes(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                if (nArray[i][j] != 2) continue;
                nArray[i][j] = 0;
            }
        }
    }

    public static void clearCovers(int[] nArray, int[] nArray2) {
        int n;
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = 0;
        }
    }

    public static int hg_step6(int n, double[][] dArray, int[] nArray, int[] nArray2, double d) {
        double d2 = HungarianAlgorithm.findSmallest(dArray, nArray, nArray2, d);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray[i] == 1) {
                    dArray[i][j] = dArray[i][j] + d2;
                }
                if (nArray2[j] != 0) continue;
                dArray[i][j] = dArray[i][j] - d2;
            }
        }
        n = 4;
        return n;
    }

    public static double findSmallest(double[][] dArray, int[] nArray, int[] nArray2, double d) {
        double d2 = d;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (nArray[i] != 0 || nArray2[j] != 0 || !(d2 > dArray[i][j])) continue;
                d2 = dArray[i][j];
            }
        }
        return d2;
    }

    public static void main(String[] stringArray) {
        double[][] dArrayArray = new double[][]{};
        int[][] nArray = HungarianAlgorithm.hgAlgorithm(dArrayArray, "min");
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                System.err.print(" " + nArray[i][j]);
            }
            System.err.println();
        }
    }
}

