/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.ConcatenatedIterator;
import fr.inrialpes.exmo.align.impl.Similarity;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public abstract class MatrixMeasure
implements Similarity {
    public OWLOntology onto1 = null;
    public OWLOntology onto2 = null;
    public int nbclass1 = 0;
    public int nbclass2 = 0;
    public int nbprop1 = 0;
    public int nbprop2 = 0;
    public int nbind1 = 0;
    public int nbind2 = 0;
    public int i;
    public int j = 0;
    public int l1;
    public int l2 = 0;
    public HashMap classlist2 = null;
    public HashMap classlist1 = null;
    public HashMap proplist2 = null;
    public HashMap proplist1 = null;
    public HashMap indlist2 = null;
    public HashMap indlist1 = null;
    private NumberFormat numFormat = null;
    public double[][] clmatrix;
    public double[][] prmatrix;
    public double[][] indmatrix;

    @Override
    public void initialize(OWLOntology oWLOntology, OWLOntology oWLOntology2, Alignment alignment) {
        this.initialize(oWLOntology, oWLOntology2);
    }

    @Override
    public void initialize(OWLOntology oWLOntology, OWLOntology oWLOntology2) {
        this.onto1 = oWLOntology;
        this.onto2 = oWLOntology2;
        this.classlist2 = new HashMap();
        this.classlist1 = new HashMap();
        this.proplist2 = new HashMap();
        this.proplist1 = new HashMap();
        this.indlist2 = new HashMap();
        this.indlist1 = new HashMap();
        try {
            Iterator iterator = this.onto2.getClasses().iterator();
            while (iterator.hasNext()) {
                this.classlist2.put(iterator.next(), new Integer(this.nbclass2));
                ++this.nbclass2;
            }
            iterator = this.onto1.getClasses().iterator();
            while (iterator.hasNext()) {
                this.classlist1.put(iterator.next(), new Integer(this.nbclass1));
                ++this.nbclass1;
            }
            this.clmatrix = new double[this.nbclass1 + 1][this.nbclass2 + 1];
            iterator = this.onto2.getObjectProperties().iterator();
            while (iterator.hasNext()) {
                this.proplist2.put(iterator.next(), new Integer(this.nbprop2));
                ++this.nbprop2;
            }
            iterator = this.onto2.getDataProperties().iterator();
            while (iterator.hasNext()) {
                this.proplist2.put(iterator.next(), new Integer(this.nbprop2));
                ++this.nbprop2;
            }
            iterator = this.onto1.getObjectProperties().iterator();
            while (iterator.hasNext()) {
                this.proplist1.put(iterator.next(), new Integer(this.nbprop1));
                ++this.nbprop1;
            }
            iterator = this.onto1.getDataProperties().iterator();
            while (iterator.hasNext()) {
                this.proplist1.put(iterator.next(), new Integer(this.nbprop1));
                ++this.nbprop1;
            }
            this.prmatrix = new double[this.nbprop1 + 1][this.nbprop2 + 1];
            for (OWLIndividual oWLIndividual : this.onto2.getIndividuals()) {
                if (oWLIndividual.getURI() == null) continue;
                this.indlist2.put(oWLIndividual, new Integer(this.nbind2));
                ++this.nbind2;
            }
            for (OWLIndividual oWLIndividual : this.onto1.getIndividuals()) {
                if (oWLIndividual.getURI() == null) continue;
                this.indlist1.put(oWLIndividual, new Integer(this.nbind1));
                ++this.nbind1;
            }
            this.indmatrix = new double[this.nbind1 + 1][this.nbind2 + 1];
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
    }

    @Override
    public void compute(Parameters parameters) {
        try {
            for (OWLClass oWLClass : this.onto2.getClasses()) {
                for (OWLClass oWLClass2 : this.onto1.getClasses()) {
                    this.clmatrix[((Integer)this.classlist1.get((Object)oWLClass2)).intValue()][((Integer)this.classlist2.get((Object)oWLClass)).intValue()] = this.measure(oWLClass2, oWLClass);
                }
            }
            for (OWLClass oWLClass : this.onto2.getIndividuals()) {
                if (this.indlist2.get(oWLClass) == null) continue;
                for (OWLClass oWLClass2 : this.onto1.getIndividuals()) {
                    if (this.indlist1.get(oWLClass2) == null) continue;
                    this.indmatrix[((Integer)this.indlist1.get((Object)oWLClass2)).intValue()][((Integer)this.indlist2.get((Object)oWLClass)).intValue()] = this.measure((OWLIndividual)oWLClass2, (OWLIndividual)oWLClass);
                }
            }
            ConcatenatedIterator concatenatedIterator = new ConcatenatedIterator(this.onto2.getObjectProperties().iterator(), this.onto2.getDataProperties().iterator());
            while (concatenatedIterator.hasNext()) {
                OWLClass oWLClass;
                oWLClass = (OWLProperty)concatenatedIterator.next();
                ConcatenatedIterator concatenatedIterator2 = new ConcatenatedIterator(this.onto1.getObjectProperties().iterator(), this.onto1.getDataProperties().iterator());
                while (concatenatedIterator2.hasNext()) {
                    OWLClass oWLClass2;
                    oWLClass2 = (OWLProperty)concatenatedIterator2.next();
                    this.prmatrix[((Integer)this.proplist1.get((Object)oWLClass2)).intValue()][((Integer)this.proplist2.get((Object)oWLClass)).intValue()] = this.measure((OWLProperty)oWLClass2, (OWLProperty)oWLClass);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public double getIndividualSimilarity(OWLIndividual oWLIndividual, OWLIndividual oWLIndividual2) {
        return this.indmatrix[(Integer)this.indlist1.get(oWLIndividual)][(Integer)this.indlist2.get(oWLIndividual2)];
    }

    @Override
    public double getClassSimilarity(OWLClass oWLClass, OWLClass oWLClass2) {
        return this.clmatrix[(Integer)this.classlist1.get(oWLClass)][(Integer)this.classlist2.get(oWLClass2)];
    }

    @Override
    public double getPropertySimilarity(OWLProperty oWLProperty, OWLProperty oWLProperty2) {
        return this.prmatrix[(Integer)this.proplist1.get(oWLProperty)][(Integer)this.proplist2.get(oWLProperty2)];
    }

    @Override
    public void printClassSimilarityMatrix(String string) {
        this.numFormat = NumberFormat.getInstance();
        this.numFormat.setMinimumFractionDigits(2);
        this.numFormat.setMaximumFractionDigits(2);
        System.out.print("\\begin{tabular}{r|");
        for (int i = 0; i < this.nbclass1; ++i) {
            System.out.print("c");
        }
        System.out.println("}");
        try {
            for (OWLClass oWLClass : this.onto1.getClasses()) {
                System.out.print(" & \\rotatebox{90}{" + oWLClass.getURI().getFragment() + "}");
            }
            System.out.println(" \\\\ \\hline");
            for (OWLClass oWLClass : this.onto2.getClasses()) {
                System.out.print(oWLClass.getURI().getFragment());
                for (OWLClass oWLClass2 : this.onto1.getClasses()) {
                    System.out.print(" & " + this.numFormat.format(this.clmatrix[(Integer)this.classlist1.get(oWLClass2)][(Integer)this.classlist2.get(oWLClass)]));
                }
                System.out.println("\\\\");
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        System.out.println("\n\\end{tabular}");
    }

    @Override
    public void printPropertySimilarityMatrix(String string) {
    }

    @Override
    public void printIndividualSimilarityMatrix(String string) {
    }
}

