/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.OWLAPICell;
import fr.inrialpes.exmo.align.impl.OntologyCache;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import java.net.URI;
import java.util.Enumeration;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLManager;
import org.xml.sax.SAXException;

public class OWLAPIAlignment
extends BasicAlignment {
    protected OWLAPIAlignment init = null;

    @Override
    public void init(Object object, Object object2) throws AlignmentException {
        this.init(object, object2, null);
    }

    @Override
    public void init(Object object, Object object2, Object object3) throws AlignmentException {
        OntologyCache ontologyCache = null;
        ontologyCache = object3 instanceof OntologyCache ? (OntologyCache)object3 : (OntologyCache)null;
        if (object instanceof OWLOntology && object2 instanceof OWLOntology) {
            super.init(object, object2, object3);
        } else if (object instanceof URI && object2 instanceof URI) {
            this.setFile1((URI)object);
            this.setFile2((URI)object2);
            try {
                super.init(OWLAPIAlignment.loadOntology(this.getFile1(), ontologyCache), OWLAPIAlignment.loadOntology(this.getFile2(), ontologyCache));
            }
            catch (OWLException oWLException) {
                throw new AlignmentException("Cannot load ontologies", (Exception)((Object)oWLException));
            }
            catch (SAXException sAXException) {
                throw new AlignmentException("Cannot load ontologies", (Exception)sAXException);
            }
        } else {
            throw new AlignmentException("arguments must be OWLOntology or URI");
        }
    }

    public void loadInit(Alignment alignment) throws AlignmentException {
        this.loadInit(alignment, null);
    }

    public void loadInit(Alignment alignment, OntologyCache ontologyCache) throws AlignmentException {
        if (alignment instanceof URIAlignment) {
            try {
                this.init = OWLAPIAlignment.toOWLAPIAlignment((URIAlignment)alignment, ontologyCache);
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (OWLException oWLException) {
                oWLException.printStackTrace();
            }
        } else if (alignment instanceof OWLAPIAlignment) {
            this.init = (OWLAPIAlignment)alignment;
        }
    }

    @Override
    public URI getOntology1URI() throws AlignmentException {
        try {
            return ((OWLOntology)this.onto1).getLogicalURI();
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("URI conversion error for " + this.onto1, (Exception)((Object)oWLException));
        }
    }

    @Override
    public URI getOntology2URI() throws AlignmentException {
        try {
            return ((OWLOntology)this.onto2).getLogicalURI();
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("URI conversion error for " + this.onto2, (Exception)((Object)oWLException));
        }
    }

    @Override
    public void setOntology1(Object object) throws AlignmentException {
        if (!(object instanceof OWLOntology)) {
            throw new AlignmentException("arguments must be OWLOntology");
        }
        super.setOntology1(object);
    }

    @Override
    public void setOntology2(Object object) throws AlignmentException {
        if (!(object instanceof OWLOntology)) {
            throw new AlignmentException("arguments must be OWLOntology");
        }
        super.setOntology2(object);
    }

    @Override
    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        if (!(object instanceof OWLEntity) || !(object2 instanceof OWLEntity)) {
            throw new AlignmentException("arguments must be OWLEntities");
        }
        return super.addAlignCell(string, object, object2, relation, d);
    }

    @Override
    public Cell addAlignCell(Object object, Object object2, String string, double d) throws AlignmentException {
        if (!(object instanceof OWLEntity) || !(object2 instanceof OWLEntity)) {
            throw new AlignmentException("arguments must be OWLEntities");
        }
        return super.addAlignCell(object, object2, string, d);
    }

    @Override
    public Cell addAlignCell(Object object, Object object2) throws AlignmentException {
        if (!(object instanceof OWLEntity) || !(object2 instanceof OWLEntity)) {
            throw new AlignmentException("arguments must be OWLEntities");
        }
        return super.addAlignCell(object, object2);
    }

    @Override
    public Cell createCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        return new OWLAPICell(string, (OWLEntity)object, (OWLEntity)object2, relation, d);
    }

    @Override
    public Set getAlignCells1(Object object) throws AlignmentException {
        if (object instanceof OWLEntity) {
            return super.getAlignCells1(object);
        }
        throw new AlignmentException("argument must be OWLEntity");
    }

    @Override
    public Set getAlignCells2(Object object) throws AlignmentException {
        if (object instanceof OWLEntity) {
            return super.getAlignCells2(object);
        }
        throw new AlignmentException("argument must be OWLEntity");
    }

    @Override
    public Cell getAlignCell1(Object object) throws AlignmentException {
        if (BasicAlignment.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("deprecated (use getAlignCells1 instead)");
        }
        if (object instanceof OWLEntity) {
            return super.getAlignCell1(object);
        }
        throw new AlignmentException("argument must be OWLEntity");
    }

    @Override
    public Cell getAlignCell2(Object object) throws AlignmentException {
        if (BasicAlignment.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("deprecated (use getAlignCells2 instead)");
        }
        if (object instanceof OWLEntity) {
            return super.getAlignCell2(object);
        }
        throw new AlignmentException("argument must be OWLEntity");
    }

    @Override
    public Object clone() {
        OWLAPIAlignment oWLAPIAlignment = new OWLAPIAlignment();
        try {
            oWLAPIAlignment.init((OWLOntology)this.getOntology1(), (OWLOntology)this.getOntology2());
        }
        catch (AlignmentException alignmentException) {
            // empty catch block
        }
        oWLAPIAlignment.setType(this.getType());
        oWLAPIAlignment.setLevel(this.getLevel());
        oWLAPIAlignment.setFile1(this.getFile1());
        oWLAPIAlignment.setFile2(this.getFile2());
        Enumeration enumeration = this.extensions.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            oWLAPIAlignment.setExtension(string, this.getExtension(string));
        }
        oWLAPIAlignment.getExtensions().unsetParameter("id");
        try {
            oWLAPIAlignment.ingest(this);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return oWLAPIAlignment;
    }

    @Override
    public URIAlignment toURIAlignment() throws AlignmentException {
        String string;
        URIAlignment uRIAlignment = new URIAlignment();
        uRIAlignment.init(this.getOntology1URI(), this.getOntology2URI());
        uRIAlignment.setType(this.getType());
        uRIAlignment.setLevel(this.getLevel());
        uRIAlignment.setFile1(this.getFile1());
        uRIAlignment.setFile2(this.getFile2());
        Enumeration enumeration = this.extensions.getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            uRIAlignment.setExtension(string, this.getExtension(string));
        }
        enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            string = (Cell)enumeration.nextElement();
            try {
                uRIAlignment.addAlignCell(string.getId(), string.getObject1AsURI(), string.getObject2AsURI(), string.getRelation(), string.getStrength());
            }
            catch (AlignmentException alignmentException) {}
        }
        return uRIAlignment;
    }

    public static OWLAPIAlignment toOWLAPIAlignment(URIAlignment uRIAlignment, OntologyCache ontologyCache) throws AlignmentException, SAXException, OWLException {
        String string;
        OWLAPIAlignment oWLAPIAlignment = new OWLAPIAlignment();
        oWLAPIAlignment.init(uRIAlignment.getFile1(), uRIAlignment.getFile2(), ontologyCache);
        oWLAPIAlignment.setType(uRIAlignment.getType());
        oWLAPIAlignment.setLevel(uRIAlignment.getLevel());
        Enumeration enumeration = uRIAlignment.getExtensions().getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            oWLAPIAlignment.setExtension(string, uRIAlignment.getExtension(string));
        }
        enumeration = (OWLOntology)oWLAPIAlignment.getOntology1();
        string = (OWLOntology)oWLAPIAlignment.getOntology2();
        Enumeration enumeration2 = uRIAlignment.getElements();
        while (enumeration2.hasMoreElements()) {
            Cell cell = (Cell)enumeration2.nextElement();
            oWLAPIAlignment.addAlignCell(cell.getId(), OWLAPIAlignment.getEntity((OWLOntology)enumeration, cell.getObject1AsURI()), OWLAPIAlignment.getEntity((OWLOntology)string, cell.getObject2AsURI()), cell.getRelation(), cell.getStrength());
        }
        return oWLAPIAlignment;
    }

    private static OWLEntity getEntity(OWLOntology oWLOntology, URI uRI) throws OWLException, SAXException {
        OWLClass oWLClass = oWLOntology.getClass(uRI);
        if (oWLClass == null) {
            oWLClass = oWLOntology.getDataProperty(uRI);
        }
        if (oWLClass == null) {
            oWLClass = oWLOntology.getObjectProperty(uRI);
        }
        if (oWLClass == null) {
            oWLClass = oWLOntology.getIndividual(uRI);
        }
        return oWLClass;
    }

    private static OWLOntology loadOntology(URI uRI, OntologyCache ontologyCache) throws SAXException, OWLException {
        if (ontologyCache != null && ontologyCache.getOntology(uRI) != null) {
            return ontologyCache.getOntology(uRI);
        }
        OWLOntology oWLOntology = null;
        OWLRDFParser oWLRDFParser = new OWLRDFParser();
        OWLRDFErrorHandler oWLRDFErrorHandler = new OWLRDFErrorHandler(){

            public void owlFullConstruct(int n, String string) throws SAXException {
            }

            public void owlFullConstruct(int n, String string, Object object) throws SAXException {
            }

            public void error(String string) throws SAXException {
                throw new SAXException(string.toString());
            }

            public void warning(String string) throws SAXException {
                System.err.println("WARNING: " + string);
            }
        };
        oWLRDFParser.setOWLRDFErrorHandler(oWLRDFErrorHandler);
        oWLRDFParser.setConnection(OWLManager.getOWLConnection());
        oWLOntology = oWLRDFParser.parseOntology(uRI);
        if (ontologyCache != null) {
            ontologyCache.recordOntology(uRI, oWLOntology);
        }
        return oWLOntology;
    }
}

