/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public class ExtPREvaluator
extends BasicEvaluator {
    private OWLOntology onto1;
    private OWLOntology onto2;
    private double symALPHA = 0.5;
    private double symprec = 0.0;
    private double symrec = 0.0;
    private double effprec = 0.0;
    private double effrec = 0.0;
    private double orientprec = 0.0;
    private double orientrec = 0.0;
    private int nbexpected = 0;
    private int nbfound = 0;
    private double symsimilarity = 0.0;
    private double effsimilarity = 0.0;
    private double orientsimilarity = 0.0;

    public ExtPREvaluator(Alignment alignment, Alignment alignment2) {
        super(alignment, alignment2);
    }

    public double getSymPrecision() {
        return this.symprec;
    }

    public double getSymRecall() {
        return this.symrec;
    }

    public double getSymSimilarity() {
        return this.symsimilarity;
    }

    public double getEffPrecision() {
        return this.effprec;
    }

    public double getEffRecall() {
        return this.effrec;
    }

    public double getEffSimilarity() {
        return this.effsimilarity;
    }

    public double getOrientPrecision() {
        return this.orientprec;
    }

    public double getOrientRecall() {
        return this.orientrec;
    }

    public double getOrientSimilarity() {
        return this.orientsimilarity;
    }

    public int getExpected() {
        return this.nbexpected;
    }

    public int getFound() {
        return this.nbfound;
    }

    public double eval(Parameters parameters) throws AlignmentException {
        return this.eval(parameters, null);
    }

    public double eval(Parameters parameters, Object object) throws AlignmentException {
        if (!(this.align1 instanceof OWLAPIAlignment) || !(this.align2 instanceof OWLAPIAlignment)) {
            throw new AlignmentException("ExtPREvaluation: requires OWLAPIAlignments");
        }
        this.onto1 = (OWLOntology)this.align1.getOntology1();
        this.onto2 = (OWLOntology)this.align1.getOntology2();
        this.nbexpected = this.align1.nbCells();
        this.nbfound = this.align2.nbCells();
        Enumeration enumeration = this.align1.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            Set set = this.align2.getAlignCells1((Object)((OWLEntity)cell.getObject1()));
            if (set == null) continue;
            Object object2 = set.iterator();
            while (object2.hasNext() && cell != null) {
                Cell cell2 = (Cell)object2.next();
                try {
                    URI uRI = ((OWLEntity)cell.getObject2()).getURI();
                    URI uRI2 = ((OWLEntity)cell2.getObject2()).getURI();
                    if (!uRI.toString().equals(uRI2.toString())) continue;
                    this.symsimilarity += 1.0;
                    cell = null;
                }
                catch (OWLException oWLException) {
                    oWLException.printStackTrace();
                }
            }
            object2 = this.align2.getElements();
            if (cell == null) continue;
            this.symsimilarity += this.computeSymSimilarity(cell, (Enumeration)object2);
        }
        this.symprec = this.symsimilarity / (double)this.nbfound;
        this.symrec = this.symsimilarity / (double)this.nbexpected;
        this.effsimilarity = this.symsimilarity;
        this.effprec = this.effsimilarity / (double)this.nbfound;
        this.effrec = this.effsimilarity / (double)this.nbexpected;
        this.orientsimilarity = this.symsimilarity;
        this.orientprec = this.orientsimilarity / (double)this.nbfound;
        this.orientrec = this.orientsimilarity / (double)this.nbexpected;
        return this.result;
    }

    protected double computeSymSimilarity(Cell cell, Enumeration enumeration) {
        int n = 0;
        int n2 = 0;
        try {
            while (enumeration.hasMoreElements()) {
                Cell cell2 = (Cell)enumeration.nextElement();
                if (((OWLEntity)cell.getObject1()).getURI().toString().equals(((OWLEntity)cell2.getObject1()).getURI().toString())) {
                    n2 = this.relativePosition((OWLEntity)cell.getObject2(), (OWLEntity)cell2.getObject2(), this.onto2);
                    if (n2 == 0 || n2 >= n) continue;
                    n = n2;
                    continue;
                }
                if (!((OWLEntity)cell.getObject2()).getURI().toString().equals(((OWLEntity)cell2.getObject2()).getURI().toString()) || (n2 = this.relativePosition((OWLEntity)cell.getObject1(), (OWLEntity)cell2.getObject1(), this.onto1)) == 0 || n2 >= n) continue;
                n = n2;
            }
            return this.symALPHA;
        }
        catch (OWLException oWLException) {
            return 0.0;
        }
    }

    protected int relativePosition(OWLEntity oWLEntity, OWLEntity oWLEntity2, OWLOntology oWLOntology) {
        try {
            if (oWLEntity instanceof OWLClass && oWLEntity2 instanceof OWLClass) {
                this.isSuperClass((OWLClass)oWLEntity2, (OWLClass)oWLEntity, oWLOntology);
            } else {
                if (oWLEntity instanceof OWLProperty && oWLEntity2 instanceof OWLProperty) {
                    if (this.isSuperProperty((OWLProperty)oWLEntity2, (OWLProperty)oWLEntity, oWLOntology)) {
                        return -1;
                    }
                    if (this.isSuperProperty((OWLProperty)oWLEntity, (OWLProperty)oWLEntity2, oWLOntology)) {
                        return 1;
                    }
                    return 0;
                }
                if (oWLEntity instanceof OWLIndividual && oWLEntity2 instanceof OWLIndividual) {
                    return 0;
                }
            }
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        return 0;
    }

    public int superClassPosition(OWLClass oWLClass, OWLClass oWLClass2, OWLOntology oWLOntology) throws OWLException {
        int n = -this.isSuperClass(oWLClass2, oWLClass, oWLOntology);
        if (n == 0) {
            n = this.isSuperClass(oWLClass, oWLClass2, oWLOntology);
        }
        return n;
    }

    public int isSuperClass(OWLClass oWLClass, OWLClass oWLClass2, OWLOntology oWLOntology) throws OWLException {
        URI uRI = oWLClass.getURI();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = null;
        int n = 0;
        hashSet.addAll(oWLClass2.getSuperClasses(oWLOntology));
        while (!hashSet.isEmpty()) {
            hashSet2 = hashSet;
            hashSet = new HashSet();
            Iterator iterator = hashSet2.iterator();
            ++n;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof OWLClass)) continue;
                URI uRI2 = ((OWLClass)e).getURI();
                if (uRI.toString().equals(uRI2.toString())) {
                    return n;
                }
                hashSet.addAll(((OWLClass)e).getSuperClasses(oWLOntology));
            }
        }
        return 0;
    }

    public boolean isSuperProperty(OWLProperty oWLProperty, OWLProperty oWLProperty2, OWLOntology oWLOntology) throws OWLException {
        URI uRI = oWLProperty.getURI();
        for (OWLEntity oWLEntity : oWLProperty2.getSuperProperties(oWLOntology)) {
            URI uRI2 = oWLEntity.getURI();
            if (!uRI.toString().equals(uRI2.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n  xmlns:map='http://www.atl.external.lmco.com/projects/ontology/ResultsOntology.n3#'>");
        printWriter.println("  <map:output rdf:about=''>");
        try {
            printWriter.println("    <map:input1 rdf:resource=\"" + ((OWLOntology)this.align1.getOntology1()).getURI() + "\">");
            printWriter.println("    <map:input2 rdf:resource=\"" + ((OWLOntology)this.align1.getOntology2()).getURI() + "\">");
        }
        catch (OWLException oWLException) {
            oWLException.printStackTrace();
        }
        printWriter.print("    <map:symmetricprecision>");
        printWriter.print(this.symprec);
        printWriter.print("</map:symmetricprecision>\n    <map:symmetricrecall>");
        printWriter.print(this.symrec);
        printWriter.print("</map:symmetricrecall>\n    <map:effortbasedprecision>");
        printWriter.print(this.effprec);
        printWriter.print("</map:effortbasedprecision>\n    <map:effortbasedrecall>");
        printWriter.print(this.effrec);
        printWriter.print("</map:effortbasedrecall>\n    <map:orientedprecision>");
        printWriter.print(this.orientprec);
        printWriter.print("</map:orientedprecision>\n    <map:orientedrecall>");
        printWriter.print(this.orientrec);
        printWriter.print("</map:orientedrecall>\n  </map:output>\n</rdf:RDF>\n");
    }
}

