/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import fr.inrialpes.exmo.align.impl.eval.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;

public class PRGraphEvaluator
extends BasicEvaluator {
    private int STEP = 10;
    private double[] precisions = null;
    private Vector points = new Vector();

    public PRGraphEvaluator(Alignment alignment, Alignment alignment2) {
        super(alignment, alignment2);
    }

    public double eval(Parameters parameters) throws AlignmentException {
        return this.eval(parameters, null);
    }

    public double eval(Parameters parameters, Object object) throws AlignmentException {
        Object object2;
        int n = this.align1.nbCells();
        int n2 = 0;
        int n3 = 0;
        if (parameters.getParameter("step") != null) {
            this.STEP = (Integer)parameters.getParameter("step");
        }
        this.precisions = new double[this.STEP + 1];
        TreeSet treeSet = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) throws ClassCastException {
                try {
                    if (object instanceof Cell && object2 instanceof Cell) {
                        if (((Cell)object).getStrength() > ((Cell)object2).getStrength()) {
                            return -1;
                        }
                        if (((Cell)object).getStrength() < ((Cell)object2).getStrength()) {
                            return 1;
                        }
                        if (((Cell)object).getObject1AsURI().getFragment() == null || ((Cell)object2).getObject1AsURI().getFragment() == null) {
                            return -1;
                        }
                        if (((Cell)object).getObject1AsURI().getFragment().compareTo(((Cell)object2).getObject1AsURI().getFragment()) > 0) {
                            return -1;
                        }
                        if (((Cell)object).getObject1AsURI().getFragment().compareTo(((Cell)object2).getObject1AsURI().getFragment()) < 0) {
                            return 1;
                        }
                        if (((Cell)object).getObject2AsURI().getFragment() == null || ((Cell)object2).getObject2AsURI().getFragment() == null) {
                            return -1;
                        }
                        if (((Cell)object).getObject2AsURI().getFragment().compareTo(((Cell)object2).getObject2AsURI().getFragment()) > 0) {
                            return -1;
                        }
                        return 1;
                    }
                    throw new ClassCastException();
                }
                catch (AlignmentException alignmentException) {
                    alignmentException.printStackTrace();
                    return 0;
                }
            }
        });
        Object object3 = this.align2.getElements();
        while (object3.hasMoreElements()) {
            treeSet.add(object3.nextElement());
        }
        this.points.add(new Pair(0.0, 1.0));
        object3 = treeSet.iterator();
        while (object3.hasNext()) {
            ++n2;
            Cell cell = (Cell)object3.next();
            Set set = this.align1.getAlignCells1(cell.getObject1());
            if (set == null) continue;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && cell != null) {
                Cell cell2 = (Cell)iterator.next();
                URI uRI = cell2.getObject2AsURI();
                object2 = cell.getObject2AsURI();
                if (!uRI.toString().equals(((URI)object2).toString())) continue;
                double d = (double)(++n3) / (double)n;
                double d2 = (double)n3 / (double)n2;
                this.points.add(new Pair(d, d2));
                cell = null;
            }
        }
        this.points.add(new Pair(1.0, 0.0));
        int n4 = this.STEP;
        double d = (double)n4 / (double)this.STEP;
        double d3 = 0.0;
        for (int i = this.points.size() - 1; i >= 0; --i) {
            object2 = (Pair)this.points.get(i);
            while (((Pair)object2).getX() < d) {
                this.precisions[n4] = d3;
                d = (double)(--n4) / (double)this.STEP;
            }
            if (!(((Pair)object2).getY() > d3)) continue;
            d3 = ((Pair)object2).getY();
        }
        this.precisions[0] = d3;
        return 0.0;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>");
        printWriter.println("  <output rdf:about=''>");
        for (int i = 0; i <= this.STEP; ++i) {
            printWriter.print("    <step>\n      <recall>");
            printWriter.print((double)i / (double)this.STEP);
            printWriter.print("</recall>\n      <precision>");
            printWriter.print(this.precisions[i]);
            printWriter.print("</precision>\n    </step>\n");
        }
        printWriter.print("  </output>\n</rdf:RDF>\n");
        this.writePlot(printWriter);
    }

    public void writeFullPlot(PrintWriter printWriter) throws IOException {
        for (int i = 0; i < this.points.size(); ++i) {
            Pair pair = (Pair)this.points.get(i);
            printWriter.println(pair.getX() + " " + pair.getY());
        }
    }

    public void writePlot(PrintWriter printWriter) throws IOException {
        for (int i = 0; i < this.STEP + 1; ++i) {
            printWriter.println((double)i / 10.0 + "\t" + this.precisions[i]);
        }
    }

    public double getPrecision(int n) {
        return this.precisions[n];
    }
}

