/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicAlignment;
import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;

public class PRecEvaluator
extends BasicEvaluator {
    private double precision = 0.0;
    private double recall = 0.0;
    private double fallout = 0.0;
    private double overall = 0.0;
    private double fmeasure = 0.0;
    private long time = 0L;
    private int nbexpected = 0;
    private int nbfound = 0;
    private int nbcorrect = 0;

    public PRecEvaluator(Alignment alignment, Alignment alignment2) throws AlignmentException {
        super(((BasicAlignment)alignment).toURIAlignment(), ((BasicAlignment)alignment2).toURIAlignment());
    }

    public void init() {
        this.precision = 0.0;
        this.recall = 0.0;
        this.fallout = 0.0;
        this.overall = 0.0;
        this.fmeasure = 0.0;
        this.time = 0L;
        this.nbexpected = 0;
        this.nbfound = 0;
        this.nbcorrect = 0;
    }

    public double eval(Parameters parameters) throws AlignmentException {
        return this.eval(parameters, null);
    }

    public double eval(Parameters parameters, Object object) throws AlignmentException {
        this.init();
        this.nbexpected = 0;
        this.nbfound = this.align2.nbCells();
        this.precision = 0.0;
        this.recall = 0.0;
        Object object2 = this.align1.getElements();
        while (object2.hasMoreElements()) {
            Cell cell = (Cell)object2.nextElement();
            URI uRI = cell.getObject2AsURI();
            Set set = this.align2.getAlignCells1(cell.getObject1());
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext() && cell != null) {
                    Cell cell2 = (Cell)iterator.next();
                    URI uRI2 = cell2.getObject2AsURI();
                    if (!uRI.toString().equals(uRI2.toString())) continue;
                    ++this.nbcorrect;
                    cell = null;
                }
            }
            ++this.nbexpected;
        }
        this.precision = (double)this.nbcorrect / (double)this.nbfound;
        this.recall = (double)this.nbcorrect / (double)this.nbexpected;
        this.fallout = (double)(this.nbfound - this.nbcorrect) / (double)this.nbfound;
        this.fmeasure = 2.0 * this.precision * this.recall / (this.precision + this.recall);
        this.overall = this.recall * (2.0 - 1.0 / this.precision);
        this.result = this.recall / this.precision;
        object2 = this.align2.getExtension("time");
        if (object2 != null) {
            this.time = Long.parseLong((String)object2);
        }
        return this.result;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version='1.0' encoding='utf-8' standalone='yes'?>");
        printWriter.println("<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n  xmlns:map='http://www.atl.external.lmco.com/projects/ontology/ResultsOntology.n3#'>");
        printWriter.println("  <map:output rdf:about=''>");
        try {
            printWriter.println("    <map:input1 rdf:resource=\"" + this.align1.getOntology1URI() + "\"/>");
            printWriter.println("    <map:input2 rdf:resource=\"" + this.align1.getOntology2URI() + "\"/>");
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        printWriter.print("    <map:precision>");
        printWriter.print(this.precision);
        printWriter.print("</map:precision>\n    <map:recall>");
        printWriter.print(this.recall);
        printWriter.print("</map:recall>\n    <fallout>");
        printWriter.print(this.fallout);
        printWriter.print("</fallout>\n    <map:fMeasure>");
        printWriter.print(this.fmeasure);
        printWriter.print("</map:fMeasure>\n    <map:oMeasure>");
        printWriter.print(this.overall);
        printWriter.print("</map:oMeasure>\n");
        if (this.time != 0L) {
            printWriter.print("    <time>" + this.time + "</time>\n");
        }
        printWriter.print("    <result>" + this.result);
        printWriter.print("</result>\n  </map:output>\n</rdf:RDF>\n");
    }

    public double getPrecision() {
        return this.precision;
    }

    public double getRecall() {
        return this.recall;
    }

    public double getOverall() {
        return this.overall;
    }

    public double getFallout() {
        return this.fallout;
    }

    public double getFmeasure() {
        return this.fmeasure;
    }

    public int getExpected() {
        return this.nbexpected;
    }

    public int getFound() {
        return this.nbfound;
    }

    public int getCorrect() {
        return this.nbcorrect;
    }

    public long getTime() {
        return this.time;
    }
}

