/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.eval;

import fr.inrialpes.exmo.align.impl.BasicEvaluator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLProperty;

public class SymMeanEvaluator
extends BasicEvaluator {
    private double classScore = 0.0;
    private double propScore = 0.0;
    private double indScore = 0.0;

    public SymMeanEvaluator(Alignment alignment, Alignment alignment2) {
        super(alignment, alignment2);
    }

    public double eval(Parameters parameters) throws AlignmentException {
        return this.eval(parameters, null);
    }

    public double eval(Parameters parameters, Object object) throws AlignmentException {
        Cell cell;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.result = 0.0;
        this.classScore = 0.0;
        this.propScore = 0.0;
        this.indScore = 0.0;
        Enumeration enumeration = this.align1.getElements();
        while (enumeration.hasMoreElements()) {
            Set set;
            cell = (Cell)enumeration.nextElement();
            if (cell.getObject1() instanceof OWLClass) {
                ++n;
            } else if (cell.getObject1() instanceof OWLProperty) {
                ++n2;
            } else {
                ++n3;
            }
            if ((set = this.align2.getAlignCells1((Object)((OWLEntity)cell.getObject1()))) == null) continue;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && cell != null) {
                Cell cell2 = (Cell)iterator.next();
                if (cell.getObject2() != cell2.getObject2()) continue;
                if (cell.getObject2() instanceof OWLClass) {
                    this.classScore = this.classScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
                    continue;
                }
                if (cell.getObject2() instanceof OWLProperty) {
                    this.propScore = this.propScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
                    continue;
                }
                this.indScore = this.indScore + 1.0 - Math.abs(cell2.getStrength() - cell.getStrength());
            }
        }
        enumeration = this.align2.getElements();
        while (enumeration.hasMoreElements()) {
            cell = (Cell)enumeration.nextElement();
            if (cell.getObject1() instanceof OWLClass) {
                ++n;
                continue;
            }
            if (cell.getObject1() instanceof OWLProperty) {
                ++n2;
                continue;
            }
            ++n3;
        }
        this.result = 2.0 * (this.classScore + this.propScore + this.indScore) / (double)(n + n2 + n3);
        this.classScore = 2.0 * this.classScore / (double)n;
        this.propScore = 2.0 * this.propScore / (double)n2;
        this.indScore = 2.0 * this.indScore / (double)n3;
        return this.result;
    }

    @Override
    public void write(PrintWriter printWriter) throws IOException {
        printWriter.print("<rdf:RDF>\n  <Evaluation class=\"SymMeanEvaluator\">\n    <class>");
        printWriter.print(this.classScore);
        printWriter.print("</class>\n    <properties>");
        printWriter.print(this.propScore);
        printWriter.print("</properties>\n    <individuals>");
        printWriter.print(this.indScore);
        printWriter.print("</individuals>\n    <result>");
        printWriter.print(this.result);
        printWriter.print("</result>\n  </Evaluation>\n</rdf:RDF>\n");
    }
}

