/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.method;

import fr.inrialpes.exmo.align.impl.DistanceAlignment;
import fr.inrialpes.exmo.align.impl.MatrixMeasure;
import fr.inrialpes.exmo.align.impl.method.StringDistances;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLProperty;

public class EditDistNameAlignment
extends DistanceAlignment
implements AlignmentProcess {
    public EditDistNameAlignment() {
        this.setSimilarity(new MatrixMeasure(){

            @Override
            public double measure(OWLClass oWLClass, OWLClass oWLClass2) throws OWLException {
                String string = oWLClass.getURI().getFragment();
                String string2 = oWLClass2.getURI().getFragment();
                if (string == null || string2 == null) {
                    return 1.0;
                }
                return StringDistances.levenshteinDistance(string.toLowerCase(), string2.toLowerCase()) / EditDistNameAlignment.this.max(string.length(), string2.length());
            }

            @Override
            public double measure(OWLProperty oWLProperty, OWLProperty oWLProperty2) throws OWLException {
                String string = oWLProperty.getURI().getFragment();
                String string2 = oWLProperty2.getURI().getFragment();
                if (string == null || string2 == null) {
                    return 1.0;
                }
                return StringDistances.levenshteinDistance(string.toLowerCase(), string2.toLowerCase()) / EditDistNameAlignment.this.max(string.length(), string2.length());
            }

            @Override
            public double measure(OWLIndividual oWLIndividual, OWLIndividual oWLIndividual2) throws OWLException {
                String string = oWLIndividual.getURI().getFragment();
                String string2 = oWLIndividual2.getURI().getFragment();
                if (string == null || string2 == null) {
                    return 1.0;
                }
                return StringDistances.levenshteinDistance(string.toLowerCase(), string2.toLowerCase()) / EditDistNameAlignment.this.max(string.length(), string2.length());
            }
        });
    }

    private double max(double d, double d2) {
        if (d > d2) {
            return d;
        }
        return d2;
    }
}

